/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class ReadOnlyHandler
implements EventHandler {
    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=-10700)
    public void cleanReadOnlyFields(EventContext context) {
        String event = context.getEvent();
        List<Map<String, Object>> entries = CdsServiceUtils.getEntities(context);
        CdsModelUtils.visitDeep(context.getTarget(), entries, (entity, data, parent) -> {
            Set readOnlyElementNames = entity.elements().filter(element -> this.isReadOnly((CdsElement)element, event)).map(e -> e.getName()).collect(Collectors.toSet());
            if (readOnlyElementNames.isEmpty()) {
                return;
            }
            for (Map map : data) {
                for (String e2 : readOnlyElementNames) {
                    map.remove(e2);
                }
            }
        });
    }

    public boolean isReadOnly(CdsElement element, String event) {
        boolean onInsert;
        if (element == null) {
            return false;
        }
        boolean onUpdate = CdsAnnotations.ON_UPDATE.getOrDefault((CdsAnnotatable)element) != null;
        boolean bl = onInsert = CdsAnnotations.ON_INSERT.getOrDefault((CdsAnnotatable)element) != null;
        if (onUpdate || onInsert && !"UPSERT".equals(event)) {
            return true;
        }
        boolean readOnly = (Boolean)CdsAnnotations.READONLY.getOrDefault((CdsAnnotatable)element);
        boolean fieldControlReadOnly = (Boolean)CdsAnnotations.FIELD_CONTROL_READONLY.getOrDefault((CdsAnnotatable)element);
        Map commonFieldControl = (Map)CdsAnnotations.COMMON_FIELDCONTROL.getOrDefault((CdsAnnotatable)element);
        if (readOnly || fieldControlReadOnly || commonFieldControl != null && "ReadOnly".equals(commonFieldControl.get("#"))) {
            return true;
        }
        boolean coreComputed = (Boolean)CdsAnnotations.CORE_COMPUTED.getOrDefault((CdsAnnotatable)element);
        if (coreComputed && !onUpdate && !onInsert && !element.isKey()) {
            return true;
        }
        boolean coreImmutable = (Boolean)CdsAnnotations.CORE_IMMUTABLE.getOrDefault((CdsAnnotatable)element);
        if (coreImmutable && "UPDATE".equals(event)) {
            return true;
        }
        return element.isVirtual();
    }
}

