/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.impl.parser.builder.SortSpecBuilder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnSelectList;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStar;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.draft.DraftModifier;
import com.sap.cds.services.impl.draft.ReferenceModifier;
import com.sap.cds.services.impl.draft.SelectListModifier;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;
import java.util.List;

public class ColumnsModifier
implements CqnModifier {
    private final boolean forDraftEntity;
    private final CdsEntity target;
    private final EventContext context;

    public ColumnsModifier(CdsEntity target, EventContext context) {
        this.target = target;
        this.forDraftEntity = target.getQualifiedName().endsWith("_drafts");
        this.context = context;
    }

    public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
        if (items.isEmpty() && (!this.forDraftEntity && DraftUtils.isDraftEnabled((CdsEntity)this.target) || "DraftAdministrativeData".equals(this.target.getName()))) {
            items.add((CqnSelectListItem)CqnStar.star());
        }
        if (items.stream().anyMatch(i -> i.isStar())) {
            if (!this.forDraftEntity && DraftUtils.isDraftEnabled((CdsEntity)this.target)) {
                items.add((CqnSelectListItem)this.element("IsActiveEntity"));
                items.add((CqnSelectListItem)this.element("HasDraftEntity"));
                items.add((CqnSelectListItem)this.element("HasActiveEntity"));
                items.add((CqnSelectListItem)this.element("DraftAdministrativeData_DraftUUID"));
            }
            if ("DraftAdministrativeData".equals(this.target.getName())) {
                items.add((CqnSelectListItem)this.element("InProcessByUser"));
            }
        }
        items = this.adaptItems(items);
        return super.items(items);
    }

    private CqnSelectListValue element(String field) {
        return CQL.get((String)field).withoutAlias();
    }

    public List<CqnSelectListItem> groupBy(List<CqnSelectListItem> groupBy) {
        return super.groupBy(this.adaptItems(groupBy));
    }

    public List<CqnSortSpecification> orderBy(List<CqnSortSpecification> orderBy) {
        ArrayList<CqnSortSpecification> specs = new ArrayList<CqnSortSpecification>(orderBy.size());
        for (CqnSortSpecification sortSpec : orderBy) {
            CqnSelectListItem newItem = this.adaptItem((CqnSelectListItem)sortSpec.item());
            specs.add(SortSpecBuilder.by((CqnSelectListValue)newItem.asValue()).order(sortSpec.order()).build());
        }
        return super.orderBy(specs);
    }

    private List<CqnSelectListItem> adaptItems(List<CqnSelectListItem> items) {
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            CqnSelectListItem item = items.get(i);
            items.set(i, this.adaptItem(item));
            if (!item.isSelectList()) continue;
            CqnSelectList selectList = item.asSelectList();
            if (DraftUtils.isDraftEnabled((CdsEntity)this.target) && selectList.ref().segments().stream().anyMatch(s -> "*".equals(s.id()))) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_EXPAND_ALL_IN_DRAFT, new Object[0]);
            }
            List<List<Boolean>> followActiveAssociations = ReferenceModifier.getAssociationDirections(this.target, selectList.ref(), this.context, null);
            if (selectList.ref().segments().size() > 1 && followActiveAssociations.size() > 1) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_PATH_IN_DRAFT, new Object[0]);
            }
            items.remove(item);
            --i;
            --size;
            for (List<Boolean> followActive : followActiveAssociations) {
                CqnSelectList newSelectList = (CqnSelectList)ExpressionVisitor.copy((CqnSelectListItem)selectList, (CqnModifier)new SelectListModifier(this.target, followActive, this.context));
                items.add((CqnSelectListItem)newSelectList);
            }
        }
        return items;
    }

    private CqnSelectListItem adaptItem(CqnSelectListItem item) {
        if (item.isValue() && item.asValue().value().isRef()) {
            CqnElementRef ref = item.asValue().value().asRef();
            ((ElementRef)ref).segments().forEach(s -> {
                if ("SiblingEntity_unsecured".equals(s.id())) {
                    s.id("SiblingEntity");
                }
            });
            return DraftModifier.adaptElement(ref, this.target, this.forDraftEntity, false, false).as(item.asValue().displayName());
        }
        return item;
    }
}

