/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.feature.config.Properties;
import com.sap.cds.feature.config.pojo.CdsProperties;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.DraftUtils;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"ApplicationLifecycleService$Default"})
public class DraftGCTimerInitializer
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(DraftGCTimerInitializer.class);
    private final CdsRuntime runtime;

    public DraftGCTimerInitializer(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    @Before(event={"APPLICATION_LIFECYCLE_PREPARED"})
    protected void initializeBackgroundGCThread() {
        CdsProperties.Drafts.GC gcConfig = Properties.getCds().getDrafts().getGc();
        if (gcConfig.isEnabled().booleanValue()) {
            Timer draftGCTimer = new Timer("Draft GC Timer", true);
            long gcInterval = gcConfig.getInterval().toMillis();
            long firstExecutionTime = ThreadLocalRandom.current().nextLong(gcInterval);
            draftGCTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        DraftUtils.gcDraftsOfAllServicesAndTenants((CdsRuntime)DraftGCTimerInitializer.this.runtime);
                    }
                    catch (Throwable t) {
                        log.error("Failed to gc drafts", t);
                    }
                }
            }, firstExecutionTime, gcInterval);
        }
    }
}

