/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.feature.config.Properties;
import com.sap.cds.feature.config.pojo.CdsProperties;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.impl.draft.DraftGCTimerInitializer;
import com.sap.cds.services.impl.draft.DraftHandler;
import com.sap.cds.services.impl.draft.DraftServiceImpl;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.DraftUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public class DraftServiceConfiguration
implements CdsRuntimeConfiguration {
    private AtomicBoolean createdDraftServices = new AtomicBoolean(false);

    public void services(CdsRuntimeConfigurer configurer) {
        CdsModel model = configurer.getCdsRuntime().getCdsModel();
        model.services().filter(service -> DraftUtils.isDraftEnabled((String)service.getQualifiedName(), (CdsModel)model)).map(service -> service.getQualifiedName()).flatMap(name -> {
            List serviceConfigs = Properties.getCds().getApplication().getServicesByModel(name);
            if (serviceConfigs.isEmpty()) {
                CdsProperties.Application.ApplicationServiceConfig config = Properties.getCds().getApplication().getService(name);
                if (config.getModel() == null) {
                    return Stream.of(config);
                }
                return Stream.empty();
            }
            return serviceConfigs.stream();
        }).map(config -> new DraftServiceImpl((CdsProperties.Application.ApplicationServiceConfig)config, configurer.getCdsRuntime())).peek(config -> this.createdDraftServices.set(true)).forEach(arg_0 -> ((CdsRuntimeConfigurer)configurer).service(arg_0));
    }

    public void eventHandlers(CdsRuntimeConfigurer configurer) {
        if (this.createdDraftServices.get()) {
            configurer.eventHandler((Object)new DraftHandler(configurer.getCdsRuntime()));
            configurer.eventHandler((Object)new DraftGCTimerInitializer(configurer.getCdsRuntime()));
        }
    }
}

