/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.List;
import java.util.Map;

@ServiceName(value={"*"}, type={PersistenceService.class})
public class FieldLengthAssertionHandler
implements EventHandler {
    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=11100)
    public void runCheck(EventContext context) {
        List<Map<String, Object>> entities = CdsServiceUtils.getEntities(context);
        CdsModelUtils.visitDeep(context.getTarget(), entities, (entity, data, parent) -> entity.elementsOfType(CdsSimpleType.class).filter(element -> ((CdsSimpleType)element.getType()).getType() == CdsBaseType.STRING).forEach(element -> FieldLengthAssertionHandler.validateFieldLength(element, data)));
    }

    private static void validateFieldLength(CdsElement element, List<? extends Map<String, Object>> data) {
        Integer maxLength = (Integer)((CdsSimpleType)element.getType()).get("length");
        if (maxLength != null) {
            String elementName = element.getName();
            for (Map<String, Object> map : data) {
                int valueLength;
                String value = (String)map.get(elementName);
                if (value == null || (valueLength = value.length()) <= maxLength) continue;
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EXCEEDED_FIELD_LENGTH, new Object[]{value, elementName, maxLength});
            }
        }
    }
}

