/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.persistence.PersistenceService;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@ServiceName(value={"*"}, type={PersistenceService.class})
public class GenerateUUIDHandler
implements EventHandler {
    @Before(event={"CREATE", "UPSERT"})
    @HandlerOrder(value=11000)
    public void fillUUID(EventContext context) {
        List<Map<String, Object>> entries = CdsServiceUtils.getEntities(context);
        CdsModelUtils.visitDeep(context.getTarget(), entries, (entity, data, parent) -> entity.keyElements().filter(key -> "cds.UUID".equals(key.getType().getQualifiedName())).forEach(key -> {
            for (Map map : data) {
                if (map.get(key.getName()) != null) continue;
                map.put(key.getName(), UUID.randomUUID().toString());
            }
        }));
    }
}

