/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

@ServiceName(value={"*"}, type={PersistenceService.class})
public class ManagedAspectHandler
implements EventHandler {
    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=11000)
    public void calculateManagedFields(EventContext context) {
        String event = context.getEvent();
        List<Map<String, Object>> entries = CdsServiceUtils.getEntities(context);
        Instant now = Instant.now();
        String user = context.getUserInfo().getName() == null ? "anonymous" : context.getUserInfo().getName();
        CdsModelUtils.visitDeep(context.getTarget(), entries, (entity, data, parent) -> {
            HashSet<String> userElements = new HashSet<String>();
            HashSet<String> nowElements = new HashSet<String>();
            this.findHandledElements(entity.elements(), event, userElements, nowElements);
            if (userElements.isEmpty() && nowElements.isEmpty()) {
                return;
            }
            for (Map map : data) {
                for (String elementName : userElements) {
                    if (map.containsKey(elementName)) continue;
                    map.put(elementName, user);
                }
                for (String elementName : nowElements) {
                    if (map.containsKey(elementName)) continue;
                    map.put(elementName, now);
                }
            }
        });
    }

    private void findHandledElements(Stream<CdsElement> elements, String event, HashSet<String> userElements, HashSet<String> nowElements) {
        elements.forEach(element -> {
            Object annotationValue = null;
            if ("CREATE".equals(event)) {
                annotationValue = CdsAnnotations.ON_INSERT.getOrDefault((CdsAnnotatable)element);
            } else if ("UPDATE".equals(event) || "UPSERT".equals(event)) {
                annotationValue = CdsAnnotations.ON_UPDATE.getOrDefault((CdsAnnotatable)element);
            }
            if (annotationValue instanceof Map) {
                Object equalsValue = ((Map)annotationValue).get("=");
                if ("$now".equals(equalsValue)) {
                    nowElements.add(element.getName());
                }
                if ("$user".equals(equalsValue)) {
                    userElements.add(element.getName());
                }
                if ("now".equals(equalsValue = ((Map)annotationValue).get("#"))) {
                    nowElements.add(element.getName());
                }
                if ("user".equals(equalsValue)) {
                    userElements.add(element.getName());
                }
            }
        });
    }
}

