/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class NullElementValidator
implements EventHandler {
    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=11100)
    public void runCheck(EventContext context) {
        boolean isPartialUpdate = "UPDATE".equals(context.getEvent());
        CdsModelUtils.visitDeep(context.getTarget(), CdsServiceUtils.getEntitiesResolved(context), (entity, data, parent) -> {
            List<CdsElement> keyElements = CdsModelUtils.getAssociationKeys(parent);
            Map<CdsElement, CdsElement> reducedElements = CdsModelUtils.reduceAssociationElements(entity);
            List notNullElements = reducedElements.entrySet().stream().filter(entry -> !keyElements.contains(entry.getKey()) && !keyElements.contains(entry.getValue())).filter(entry -> this.checkNull((CdsElement)entry.getKey())).collect(Collectors.toList());
            if (notNullElements.isEmpty()) {
                return;
            }
            for (Map map : data) {
                for (Map.Entry entry2 : notNullElements) {
                    if (isPartialUpdate && !map.containsKey(((CdsElement)entry2.getKey()).getName()) && (entry2.getValue() == null || !map.containsKey(((CdsElement)entry2.getValue()).getName())) || !this.isNull(map.get(((CdsElement)entry2.getKey()).getName())) || !this.isNull(entry2.getValue()) && !this.isNull(map.get(((CdsElement)entry2.getValue()).getName()))) continue;
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.VALUE_REQUIRED, new Object[]{((CdsElement)entry2.getKey()).getName() + (entry2.getValue() != null ? "' / '" + ((CdsElement)entry2.getValue()).getName() : ""), entity.getName()});
                }
            }
        });
    }

    public boolean checkNull(CdsElement element) {
        if (element == null) {
            return false;
        }
        if (element.getType().isSimple() && ((CdsSimpleType)element.getType().as(CdsSimpleType.class)).defaultValue().isPresent()) {
            return false;
        }
        if (element.getType().isAssociation() && element.getName().endsWith("_drafts")) {
            return false;
        }
        return this.check(element);
    }

    protected abstract boolean check(CdsElement var1);

    protected abstract boolean isNull(Object var1);
}

