/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.request;

import com.sap.cds.feature.util.ClassMethods;
import com.sap.cds.services.impl.utils.ModifiedValues;
import com.sap.cds.services.request.ModifiableUserInfo;
import com.sap.cds.services.request.UserInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;

class ModifiableUserInfoImpl
implements ModifiableUserInfo {
    private final ModifiedValues modifyValues = new ModifiedValues();
    private final ModifiedValues.Property<String> id;
    private final ModifiedValues.Property<String> name;
    private final ModifiedValues.Property<String> tenant;
    private final ModifiedValues.Property<Set<String>> roles;
    private final ModifiedValues.Property<Set<String>> unrestrictedAttributes;
    private final ModifiedValues.Property<Boolean> systemUser;
    private final ModifiedValues.Property<Boolean> authenticated;
    private final ModifiedValues.MapProperty<String, List<String>> attributes;
    private final ModifiedValues.MapProperty<String, Object> additionalAttributes;
    private final UserInfo prevUserInfo;

    ModifiableUserInfoImpl(@Nonnull UserInfo prevUserInfo) {
        this.prevUserInfo = prevUserInfo;
        this.id = this.modifyValues.field("id", () -> ((UserInfo)prevUserInfo).getId());
        this.name = this.modifyValues.field("name", () -> ((UserInfo)prevUserInfo).getName());
        this.tenant = this.modifyValues.field("tenant", () -> ((UserInfo)prevUserInfo).getTenant());
        this.roles = this.modifyValues.field("roles", () -> ((UserInfo)prevUserInfo).getRoles());
        this.unrestrictedAttributes = this.modifyValues.field("unrestrictedAttributes", () -> ((UserInfo)prevUserInfo).getUnrestrictedAttributes());
        this.systemUser = this.modifyValues.field("isSystemUser", () -> ((UserInfo)prevUserInfo).isSystemUser());
        this.authenticated = this.modifyValues.field("isAuthenticated", () -> ((UserInfo)prevUserInfo).isAuthenticated());
        this.attributes = this.modifyValues.field("attributes", () -> ((UserInfo)prevUserInfo).getAttributes(), arg_0 -> ((UserInfo)prevUserInfo).getAttributeValues(arg_0));
        this.additionalAttributes = this.modifyValues.field("additionalAttributes", () -> ((UserInfo)prevUserInfo).getAdditionalAttributes(), arg_0 -> ((UserInfo)prevUserInfo).getAdditionalAttribute(arg_0));
    }

    public String getId() {
        return this.id.getValue();
    }

    public ModifiableUserInfo setId(String val) {
        this.id.modifyValue(val);
        return this;
    }

    public String getName() {
        return this.name.getValue();
    }

    public ModifiableUserInfo setName(String val) {
        this.name.modifyValue(val);
        return this;
    }

    public String getTenant() {
        return this.tenant.getValue();
    }

    public ModifiableUserInfo setTenant(String val) {
        this.tenant.modifyValue(val);
        return this;
    }

    public Set<String> getRoles() {
        return this.roles.getValue();
    }

    public boolean hasRole(String role) {
        if (this.roles.isModified()) {
            return this.getRoles().contains(role);
        }
        return this.prevUserInfo.hasRole(role);
    }

    public ModifiableUserInfo setRoles(Set<String> val) {
        this.roles.modifyValue(val);
        return this;
    }

    public ModifiableUserInfo addRole(String role) {
        if (this.roles.getModifiedValue() == null) {
            this.roles.modifyValue(new TreeSet<String>(this.getRoles()));
        }
        this.roles.getModifiedValue().add(role);
        return this;
    }

    public ModifiableUserInfo removeRole(String val) {
        if (this.roles.getModifiedValue() == null) {
            this.roles.modifyValue(new TreeSet<String>(this.getRoles()));
        }
        this.roles.getModifiedValue().remove(val);
        return this;
    }

    public List<String> getAttributeValues(String attribute) {
        List<String> result = this.attributes.getMapValue(attribute);
        return result != null ? result : Collections.emptyList();
    }

    public ModifiableUserInfo setAttributeValues(String attribute, List<String> values) {
        this.attributes.modifyMapValue(attribute, values);
        return this;
    }

    public Map<String, List<String>> getAttributes() {
        return (Map)this.attributes.getValue();
    }

    public ModifiableUserInfo setAttributes(Map<String, List<String>> val) {
        this.attributes.modifyValue(val);
        return this;
    }

    public Object getAdditionalAttribute(String name) {
        return this.additionalAttributes.getMapValue(name);
    }

    public Map<String, Object> getAdditionalAttributes() {
        return (Map)this.additionalAttributes.getValue();
    }

    public ModifiableUserInfo setAdditionalAttributes(Map<String, Object> val) {
        this.additionalAttributes.modifyValue(val);
        return this;
    }

    public ModifiableUserInfo setAdditionalAttribute(String name, Object value) {
        this.additionalAttributes.modifyMapValue(name, value);
        return this;
    }

    public Set<String> getUnrestrictedAttributes() {
        return this.unrestrictedAttributes.getValue();
    }

    public ModifiableUserInfo setUnrestrictedAttributes(Set<String> val) {
        this.unrestrictedAttributes.modifyValue(val);
        return this;
    }

    public ModifiableUserInfo addUnrestrictedAttribute(String val) {
        if (this.unrestrictedAttributes.getModifiedValue() == null) {
            this.unrestrictedAttributes.modifyValue(new TreeSet<String>(this.getUnrestrictedAttributes()));
        }
        this.unrestrictedAttributes.getModifiedValue().add(val);
        return this;
    }

    public ModifiableUserInfo removeUnrestrictedAttribute(String val) {
        if (this.unrestrictedAttributes.getModifiedValue() == null) {
            this.unrestrictedAttributes.modifyValue(new TreeSet<String>(this.getUnrestrictedAttributes()));
        }
        this.unrestrictedAttributes.getModifiedValue().remove(val);
        return this;
    }

    public boolean isAuthenticated() {
        Boolean value = this.authenticated.getValue();
        return value != null ? value : false;
    }

    public ModifiableUserInfo setIsAuthenticated(boolean val) {
        this.authenticated.modifyValue(val);
        return this;
    }

    public boolean isSystemUser() {
        Boolean value = this.systemUser.getValue();
        return value != null ? value : false;
    }

    public ModifiableUserInfo setIsSystemUser(boolean val) {
        this.systemUser.modifyValue(val);
        return this;
    }

    public boolean isPrivileged() {
        return this.prevUserInfo.isPrivileged();
    }

    public <T extends UserInfo> T as(Class<T> userInfoClazz) {
        return (T)((UserInfo)ClassMethods.as(userInfoClazz, UserInfo.class, (Object)this, this::getAdditionalAttributes));
    }
}

