/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.request;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.runtime.RequestParameters;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.LocaleUtils;
import com.sap.cds.services.utils.StringUtils;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;

@Deprecated
public class ParameterInfoImpl
implements ParameterInfo {
    private static final Instant MIN_VALID_FROM = Instant.parse("0001-01-01T00:00:00Z");
    private static final Instant MAX_VALID_TO = Instant.parse("9999-12-31T23:59:59.999999999Z");
    private final RequestParameters requestParameter;
    private Locale locale;
    private Instant validFrom;
    private Instant validTo;

    public ParameterInfoImpl(RequestParameters requestParameter) {
        this.requestParameter = requestParameter;
    }

    public String getHeader(String id) {
        return this.requestParameter.getHeader(id);
    }

    public String getQueryParameter(String key) {
        return this.requestParameter.getQueryParameter(key);
    }

    public Stream<String> getQueryParameters() {
        return this.requestParameter.getQueryParameters();
    }

    public Map<String, String> getHeaders() {
        throw new UnsupportedOperationException("RequestParameters is deprecated and does not support getHeaders()");
    }

    public Map<String, String> getQueryParams() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        this.getQueryParameters().forEach(q -> result.put((String)q, this.getQueryParameter((String)q)));
        return result;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = LocaleUtils.getLocale((String)this.getQueryParameter("sap-language"), (String)this.getHeader("x-sap-request-language"), (String)this.getHeader("Accept-Language"));
        }
        return this.locale;
    }

    public Instant getValidFrom() {
        if (this.validFrom == null) {
            this.setTemporalRange();
        }
        return this.validFrom;
    }

    public Instant getValidTo() {
        if (this.validTo == null) {
            this.setTemporalRange();
        }
        return this.validTo;
    }

    private void setTemporalRange() {
        this.validFrom = ParameterInfoImpl.parseDate(this.getQueryParameter("sap-valid-from"), "sap-valid-from");
        this.validTo = ParameterInfoImpl.parseDate(this.getQueryParameter("sap-valid-to"), "sap-valid-to");
        if (this.validFrom == null && this.validTo == null) {
            Instant validAt = ParameterInfoImpl.parseDate(this.getQueryParameter("sap-valid-at"), "sap-valid-at");
            this.validFrom = validAt == null ? Instant.now() : validAt;
            this.validTo = this.validFrom.plusMillis(1L);
            return;
        }
        if (this.validFrom == null) {
            this.validFrom = MIN_VALID_FROM;
        }
        if (this.validTo == null) {
            this.validTo = MAX_VALID_TO;
        }
    }

    private static Instant parseDate(String date, String hint) {
        if (!StringUtils.isEmpty((String)date)) {
            try {
                return Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(date));
            }
            catch (DateTimeParseException e1) {
                try {
                    TemporalAccessor accessor = DateTimeFormatter.ISO_DATE.parse(date);
                    ZoneOffset zoneOffset = ParameterInfoImpl.getZoneOffset(accessor);
                    LocalTime time = ParameterInfoImpl.getLocalTime(hint);
                    LocalDateTime dateTime = LocalDate.from(accessor).atTime(time);
                    return dateTime.toInstant(zoneOffset);
                }
                catch (DateTimeParseException e2) {
                    try {
                        return Timestamp.valueOf(date).toLocalDateTime().toInstant(ZoneOffset.UTC);
                    }
                    catch (IllegalArgumentException e3) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_DATE_VALUE, new Object[]{date, hint, e1});
                    }
                }
            }
        }
        return null;
    }

    private static ZoneOffset getZoneOffset(TemporalAccessor accessor) {
        if (accessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            return ZoneOffset.ofTotalSeconds(accessor.get(ChronoField.OFFSET_SECONDS));
        }
        return ZoneOffset.UTC;
    }

    private static LocalTime getLocalTime(String hint) {
        switch (hint) {
            default: {
                return LocalTime.MIN;
            }
            case "sap-valid-to": 
        }
        return LocalTime.MAX;
    }
}

