/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.Result;
import com.sap.cds.SessionContext;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.ql.cqn.CqnXsert;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.cds.CdsCreateEventContext;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.cds.CdsUpsertEventContext;
import com.sap.cds.services.impl.ServiceSPI;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.SessionContextUtils;
import com.sap.cds.util.PathExpressionResolver;
import java.util.List;
import java.util.Map;

public class CdsServiceUtils {
    public static PersistenceService getDefaultPersistenceService(EventContext context) {
        return (PersistenceService)context.getServiceCatalog().getService(PersistenceService.class, "PersistenceService$Default");
    }

    public static ServiceSPI getServiceSPI(Service service) {
        if (service instanceof ServiceSPI) {
            return (ServiceSPI)service;
        }
        if (service instanceof ServiceDelegator) {
            return CdsServiceUtils.getServiceSPI(((ServiceDelegator)service).getDelegatedService());
        }
        return null;
    }

    public static List<Map<String, Object>> getEntities(EventContext context) {
        switch (context.getEvent()) {
            case "CREATE": {
                return ((CdsCreateEventContext)context.as(CdsCreateEventContext.class)).getCqn().entries();
            }
            case "UPDATE": {
                return ((CdsUpdateEventContext)context.as(CdsUpdateEventContext.class)).getCqn().entries();
            }
            case "UPSERT": {
                return ((CdsUpsertEventContext)context.as(CdsUpsertEventContext.class)).getCqn().entries();
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EVENT, new Object[]{context.getEvent()});
    }

    public static List<Map<String, Object>> getEntitiesResolved(EventContext context) {
        SessionContext sessionContext = SessionContextUtils.toSessionContext((EventContext)context);
        switch (context.getEvent()) {
            case "CREATE": {
                return ((CqnInsert)PathExpressionResolver.resolvePath((CdsModel)context.getModel(), (SessionContext)sessionContext, (CqnXsert)((CdsCreateEventContext)context.as(CdsCreateEventContext.class)).getCqn())).entries();
            }
            case "UPDATE": {
                return PathExpressionResolver.resolvePath((CdsModel)context.getModel(), (SessionContext)sessionContext, (CqnUpdate)((CdsUpdateEventContext)context.as(CdsUpdateEventContext.class)).getCqn()).entries();
            }
            case "UPSERT": {
                return ((CqnUpsert)PathExpressionResolver.resolvePath((CdsModel)context.getModel(), (SessionContext)sessionContext, (CqnXsert)((CdsUpsertEventContext)context.as(CdsUpsertEventContext.class)).getCqn())).entries();
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EVENT, new Object[]{context.getEvent()});
    }

    public static Result getResult(EventContext context) {
        switch (context.getEvent()) {
            case "READ": {
                return ((CdsReadEventContext)context.as(CdsReadEventContext.class)).getResult();
            }
            case "CREATE": {
                return ((CdsCreateEventContext)context.as(CdsCreateEventContext.class)).getResult();
            }
            case "UPDATE": {
                return ((CdsUpdateEventContext)context.as(CdsUpdateEventContext.class)).getResult();
            }
            case "UPSERT": {
                return ((CdsUpsertEventContext)context.as(CdsUpsertEventContext.class)).getResult();
            }
            case "DELETE": {
                return ((CdsDeleteEventContext)context.as(CdsDeleteEventContext.class)).getResult();
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_EVENT, new Object[]{context.getEvent()});
    }
}

