/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.messaging.service;

import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.feature.config.Properties;
import com.sap.cds.services.impl.messaging.composite.MessagingCompositeService;
import com.sap.cds.services.impl.messaging.file.FileBasedMessagingBroker;
import com.sap.cds.services.impl.messaging.file.FileBasedMessagingService;
import com.sap.cds.services.impl.messaging.handlers.MessagingInitilizationHandler;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

public class MessagingServiceConfiguration implements CdsRuntimeConfiguration {

	private static final Logger logger = LoggerFactory.getLogger(FileBasedMessagingBroker.class);

	@Override
	public void services(CdsRuntimeConfigurer configurer) {
		// create the file based service instances
		Properties.getCds().getMessaging().getServicesByKind(FileBasedMessagingService.FILE_KIND).forEach(serviceConfig -> {
			if (serviceConfig.isEnabled()) {
				try {
					FileBasedMessagingService fileService = new FileBasedMessagingService(serviceConfig, configurer.getCdsRuntime().getCdsModel());
					configurer.service(fileService);
				} catch (IOException e) {
					logger.error("File-based messaging service '{}' could not create the exchange file", serviceConfig.getName(), e);
				}
			}
		});

		// create the composite service if configuration is available
		if (!Properties.getCds().getMessaging().getRoutes().isEmpty()) {
			configurer.service(new MessagingCompositeService(MessagingService.COMPOSITE_NAME, Properties.getCds().getMessaging().getRoutes(), configurer.getCdsRuntime()));
		}
	}

	@Override
	public void eventHandlers(CdsRuntimeConfigurer configurer) {
		configurer.eventHandler(new MessagingInitilizationHandler());
	}
}
