/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.outbox;

import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.changeset.ChangeSetListener;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.outbox.OutboxEnrollEventContext;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.utils.OrderConstants;

/**
 * An {@link EventHandler} to handle out box related events.
 */
@ServiceName(value = "*", type = OutboxService.class)
public class OutboxDefaultOnHandler implements EventHandler {

	@On
	@HandlerOrder(OrderConstants.On.DEFAULT_ON)
	public void handleOutboxEnrollEvent(OutboxEnrollEventContext context) {
		ChangeSetContext changeSet = context.getChangeSetContext();
		changeSet.register(new ChangeSetListener() {
			@Override
			public void beforeClose() {
				if(!changeSet.isMarkedForCancel()) {
					context.getOutboxedService().emit(context.getOutboxedContext());
				}
			}
		});

		context.setCompleted();
	}

}
