/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.request;

import com.sap.cds.services.request.ModifiableParameterInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.ParameterInfoFactory;

public class ParameterInfoFactoryImpl implements ParameterInfoFactory {

	@Override
	public ModifiableParameterInfo create(ParameterInfo parameterInfo) {
		return new ModifiableParameterInfoImpl(parameterInfo != null ? parameterInfo : emptyParameterInfo());
	}

	public static ParameterInfo emptyParameterInfo() {
		return EMPTY_PARAMETERS;
	}

	private static ParameterInfo EMPTY_PARAMETERS = new ParameterInfo() {
		// intentionally empty
	};
}
