/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.handlerregistry.resolver;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import com.sap.cds.services.impl.handlerregistry.AnnotationDescriptor;
import com.sap.cds.services.impl.handlerregistry.HandlerDescriptor;
import com.sap.cds.services.impl.handlerregistry.resolver.ArgumentResolver;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.lang.reflect.Type;
import java.util.HashMap;

public class EventContextArgumentResolver
implements ArgumentResolver {
    private static final HashMap<Type, EventContextArgumentResolver> cache = new HashMap();
    private final Class<? extends EventContext> eventContextType;

    public static EventContextArgumentResolver createIfApplicable(Class<?> type) {
        EventContextArgumentResolver cached = cache.get(type);
        if (cached != null) {
            return cached;
        }
        if (EventContext.class.isAssignableFrom(type)) {
            return new EventContextArgumentResolver(type);
        }
        return null;
    }

    private EventContextArgumentResolver(Class<?> type) {
        this.eventContextType = type;
        cache.put(type, this);
    }

    @Override
    public Object resolve(EventContext context) {
        return context.as(this.eventContextType);
    }

    @Override
    public void verifyOrThrow(HandlerDescriptor descriptor) {
        EventName eventName = this.eventContextType.getAnnotation(EventName.class);
        if (eventName == null || StringUtils.isEmpty((String)eventName.value())) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_CONTEXT_ARGUMENT_MISSING_ANNOTATION, new Object[]{descriptor.getMethodName(), this.eventContextType.getName()});
        }
        if (!eventName.value().equals("*")) {
            for (AnnotationDescriptor ad : descriptor.getAnnotations()) {
                String[] events = ad.getEvents();
                if (StringUtils.notEmpty((String[])events) == null) continue;
                if (events.length != 1) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_CONTEXT_ARGUMENT_MULTIPLE_EVENTS, new Object[]{descriptor.getMethodName(), this.eventContextType.getName()});
                }
                if (events[0].equals(eventName.value())) continue;
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_CONTEXT_ARGUMENT_MISMATCH, new Object[]{descriptor.getMethodName(), this.eventContextType.getName(), events[0]});
            }
        }
    }

    @Override
    public String[] indicateEvents() {
        return new String[]{this.eventContextType.getAnnotation(EventName.class).value()};
    }
}

