/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messaging.service;

import com.sap.cds.feature.config.Properties;
import com.sap.cds.feature.config.pojo.CdsProperties;
import com.sap.cds.services.Service;
import com.sap.cds.services.impl.messaging.composite.MessagingCompositeService;
import com.sap.cds.services.impl.messaging.file.FileBasedMessagingBroker;
import com.sap.cds.services.impl.messaging.file.FileBasedMessagingService;
import com.sap.cds.services.impl.messaging.handlers.MessagingInitilizationHandler;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingServiceConfiguration
implements CdsRuntimeConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedMessagingBroker.class);

    public void services(CdsRuntimeConfigurer configurer) {
        Properties.getCds().getMessaging().getServicesByKind("file-based-messaging").forEach(serviceConfig -> {
            if (serviceConfig.isEnabled().booleanValue()) {
                try {
                    FileBasedMessagingService fileService = new FileBasedMessagingService((CdsProperties.Messaging.MessagingServiceConfig)serviceConfig, configurer.getCdsRuntime().getCdsModel());
                    configurer.service((Service)fileService);
                }
                catch (IOException e) {
                    logger.error("File-based messaging service '{}' could not create the exchange file", (Object)serviceConfig.getName(), (Object)e);
                }
            }
        });
        if (!Properties.getCds().getMessaging().getRoutes().isEmpty()) {
            configurer.service((Service)new MessagingCompositeService("MessagingService$Composite", Properties.getCds().getMessaging().getRoutes(), configurer.getCdsRuntime()));
        }
    }

    public void eventHandlers(CdsRuntimeConfigurer configurer) {
        configurer.eventHandler((Object)new MessagingInitilizationHandler());
    }
}

