/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.cds;

import com.sap.cds.feature.config.pojo.CdsProperties.Application.ApplicationServiceConfig;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.OrderConstants;
import com.sap.cds.services.utils.services.AbstractCqnService;

public class ApplicationServiceImpl extends AbstractCqnService implements ApplicationService {

	private final String definitionName;

	public ApplicationServiceImpl(ApplicationServiceConfig config, CdsRuntime runtime) {
		super(config.getName(), runtime);
		this.definitionName = config.getModel() != null ? config.getModel() : config.getName();
		runtime.getCdsModel().getService(definitionName); // validate service exists
	}

	@On
	@HandlerOrder(OrderConstants.On.AUTO_COMPLETE)
	private void autoCompleteDeclaredEvents(EventContext context) {
		if (getDefinition().events().anyMatch(e -> context.getEvent().equals(e.getName()))) {
			context.setCompleted();
		}
	}

	@Override
	public CdsService getDefinition() {
		return RequestContext.getCurrent(runtime).getModel().getService(definitionName);
	}

}
