/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.feature.config.Properties;
import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;

public class DraftModifier
implements CqnModifier {
    private boolean activeEntityOnly;
    private boolean forDraftEntity;
    private CdsEntity entity;
    private final boolean adaptIsActiveEntity;

    public DraftModifier(CdsEntity entity, boolean adaptIsActiveEntity) {
        this(entity, false, adaptIsActiveEntity);
    }

    public DraftModifier(CdsEntity entity, boolean activeEntityOnly, boolean adaptIsActiveEntity) {
        this.entity = entity;
        this.forDraftEntity = entity.getQualifiedName().endsWith("_drafts");
        this.activeEntityOnly = activeEntityOnly;
        this.adaptIsActiveEntity = adaptIsActiveEntity;
    }

    public Value<?> ref(ElementRef<?> ref) {
        return DraftModifier.adaptElement(ref, this.entity, this.forDraftEntity, this.activeEntityOnly, this.adaptIsActiveEntity);
    }

    public static Value<?> adaptElement(CqnElementRef ref, CdsEntity entity, boolean forDraftEntity, boolean activeEntityOnly, boolean adaptIsActiveEntity) {
        ArrayList segments = new ArrayList(ref.segments());
        if (DraftModifier.referencesDraftField("IsActiveEntity", segments, entity, forDraftEntity) && adaptIsActiveEntity) {
            return CQL.literal((Object)true);
        }
        if (!activeEntityOnly && "InProcessByUser".equals(ref.targetSegment().id())) {
            return DraftModifier.createTimeoutExpression(ref);
        }
        return CQL.get(segments);
    }

    public static void insertFieldBefore(String id, List<CqnReference.Segment> segments, CqnReference.Segment toInsert) {
        for (int i = 0; i < segments.size(); ++i) {
            if (!segments.get(i).id().equals(id)) continue;
            segments.add(i, toInsert);
            return;
        }
    }

    public static Instant getTimeoutThreshold() {
        return Instant.now().minus(Properties.getCds().getDrafts().getCancellationTimeout()).truncatedTo(ChronoUnit.MILLIS);
    }

    public static ElementRef<?> changeLastSegment(CqnElementRef ref, String id) {
        ArrayList<RefSegment> result = new ArrayList<RefSegment>(ref.segments());
        result.set(result.size() - 1, CQL.refSegment((String)id));
        return CQL.get(result);
    }

    public static boolean referencesDraftField(String draftColumn, List<? extends CqnReference.Segment> segments, CdsEntity entity, boolean forDraftEntity) {
        if (segments.stream().anyMatch(s -> s.id().equalsIgnoreCase(draftColumn))) {
            for (CqnReference.Segment segment : segments) {
                String id = segment.id();
                if (draftColumn.equalsIgnoreCase(id)) {
                    return !forDraftEntity;
                }
                if (CdsModelUtils.isAssociationToParentOrChild(id, entity)) {
                    entity = entity.getTargetOf(id);
                    continue;
                }
                if ("SiblingEntity".equals(id) || "SiblingEntity_unsecured".equals(id)) {
                    forDraftEntity = !forDraftEntity;
                    continue;
                }
                if (!entity.findAssociation(id).isPresent()) continue;
                entity = entity.getTargetOf(id);
                forDraftEntity = id.endsWith("_drafts");
            }
        }
        return false;
    }

    public static Value<?> createTimeoutExpression(CqnElementRef ref) {
        ElementRef<?> refLastChangeDateTime = DraftModifier.changeLastSegment(ref, "LastChangeDateTime");
        ElementRef<?> refDraftUuid = DraftModifier.changeLastSegment(ref, "DraftUUID");
        return ExpressionBuilder.create((CqnToken[])new CqnToken[0]).plain("CASE").plain("WHEN").ref(refDraftUuid).plain("IS NULL").plain("THEN").plain("null").plain("WHEN").ref(refLastChangeDateTime).plain(">").add((CqnToken)CQL.literal((Object)DraftModifier.getTimeoutThreshold())).plain("THEN").ref(ref).plain("ELSE").plain("''").plain("END").value().type(CdsBaseType.STRING.cdsName());
    }
}

