/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messaging.composite;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.feature.config.pojo.CdsProperties;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.composite.CompositeService;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.messaging.TopicMessageEventContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.List;
import java.util.Map;

public class MessagingCompositeService
extends CompositeService
implements MessagingService {
    private static final ObjectMapper mapper = new ObjectMapper();

    public MessagingCompositeService(String name, List<CdsProperties.Composite.CompositeServiceConfig.Route> routes, CdsRuntime runtime) {
        super(MessagingCompositeService.toCompositeConfig(name, routes), runtime);
    }

    public void emit(String topic, String message) {
        TopicMessageEventContext context = TopicMessageEventContext.create((String)topic);
        context.setData(message);
        this.emit((EventContext)context);
    }

    public void emit(String topic, Map<String, Object> message) {
        this.emit(topic, this.toJson(message));
    }

    private String toJson(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[]{e});
        }
    }

    private static CdsProperties.Composite.CompositeServiceConfig toCompositeConfig(String name, List<CdsProperties.Composite.CompositeServiceConfig.Route> routes) {
        CdsProperties.Composite.CompositeServiceConfig result = new CdsProperties.Composite.CompositeServiceConfig();
        result.setName(name);
        result.setRoutes(routes);
        return result;
    }
}

