/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.google.common.base.Charsets;
import com.sap.cds.feature.config.Properties;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.util.CdsTypeUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvDataLoader {
    private static final Logger logger = LoggerFactory.getLogger(CsvDataLoader.class);
    private static final String FILE_SUFFIX = Properties.getCds().getDataSource().getCsvFileSuffix();
    private final PersistenceService db;
    private final CdsRuntime runtime;

    public CsvDataLoader(PersistenceService db, CdsRuntime runtime) {
        this.db = db;
        this.runtime = runtime;
    }

    public void load() {
        for (String path : Properties.getCds().getDataSource().getCsvPaths()) {
            File folder;
            boolean recursive = false;
            if (path.endsWith("**") && path.length() > 2) {
                path = path.substring(0, path.length() - 2);
                recursive = true;
            }
            if (!(folder = new File(path)).exists() || !folder.isDirectory()) continue;
            this.loadFolder(folder, recursive);
        }
    }

    public void loadFolder(File folder, boolean recursive) {
        for (File file : folder.listFiles()) {
            if (file.isFile() && file.getName().endsWith(FILE_SUFFIX)) {
                this.loadFile(file);
            }
            if (!recursive || !file.isDirectory()) continue;
            this.loadFolder(file, true);
        }
    }

    public void loadFile(File file) {
        try (CSV csv = new CSV(file);){
            List entries = csv.data().collect(Collectors.toList());
            if (!entries.isEmpty()) {
                Insert insert = Insert.into((CdsEntity)csv.entity()).entries(entries);
                try {
                    this.runtime.changeSetContext().run(c -> {
                        this.db.run((CqnInsert)insert);
                        if (c.isMarkedForCancel()) {
                            logger.debug("Cancelled filling {} from {}", (Object)csv.entity.getQualifiedName(), (Object)file.getPath());
                        } else {
                            logger.info("Filling {} from {}", (Object)csv.entity().getQualifiedName(), (Object)file.getPath());
                        }
                    });
                }
                catch (ServiceException e) {
                    logger.debug("Skipped filling {} from {}", new Object[]{csv.entity.getQualifiedName(), file.getPath(), e});
                }
            }
        }
        catch (IOException | UncheckedIOException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_CSV_FILE, new Object[]{file.getPath(), e});
        }
    }

    private class CSV
    implements AutoCloseable {
        private final CdsEntity entity;
        private final File file;
        private final BufferedReader br;
        private final List<CdsElement> headers;
        private String separator = ";";

        public CSV(File file) throws IOException {
            this.file = file;
            this.br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));
            String entityName = this.entityName(file.getName());
            this.entity = CsvDataLoader.this.runtime.getCdsModel().findEntity(entityName).orElseGet(() -> {
                if (entityName.endsWith("_texts")) {
                    String altEntityName = entityName.substring(0, entityName.length() - "_texts".length()) + ".texts";
                    return CsvDataLoader.this.runtime.getCdsModel().findEntity(altEntityName).orElse(null);
                }
                return null;
            });
            if (this.entity == null) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_CSV_FILE_ENTITYNOTFOUND, new Object[]{entityName, file.getPath()});
            }
            String headerLine = this.br.readLine();
            if (StringUtils.isEmpty((String)headerLine)) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_CSV_FILE_NOHEADER, new Object[]{file.getPath()});
            }
            if (headerLine.indexOf(44) >= 0) {
                if (headerLine.indexOf(59) >= 0) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_CSV_FILE_INVALIDHEADER, new Object[]{file.getPath()});
                }
                this.separator = ",";
            }
            this.headers = Arrays.stream(headerLine.split(this.separator)).map(n -> this.element(this.entity, (String)n)).collect(Collectors.toList());
        }

        public CdsEntity entity() {
            return this.entity;
        }

        public Stream<Map<String, Object>> data() {
            if (this.headers.isEmpty()) {
                return Stream.empty();
            }
            return this.br.lines().map(this::data);
        }

        private Map<String, Object> data(String dataLine) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            String[] values = dataLine.split(this.separator);
            for (int i = 0; i < this.headers.size(); ++i) {
                String value;
                CdsElement element = this.headers.get(i);
                String string = value = i >= values.length ? "" : values[i];
                if ("".equals(value) || !element.getType().isSimple()) continue;
                try {
                    row.put(element.getName(), CdsTypeUtils.parse((CdsBaseType)((CdsSimpleType)element.getType().as(CdsSimpleType.class)).getType(), (String)value));
                    continue;
                }
                catch (Exception e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_CSV_FILE_TYPEMISMATCH, new Object[]{value, element.getType().getName(), element.getName(), this.file.getPath(), e});
                }
            }
            return row;
        }

        private String entityName(String fileName) {
            return fileName.replace("-", ".").substring(0, fileName.length() - 4);
        }

        private CdsElement element(CdsEntity entity, String element) {
            return entity.elements().filter(e -> element.equalsIgnoreCase(e.getName())).findFirst().orElseThrow(() -> new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_CSV_FILE_UNKNOWNCOLUMN, new Object[]{this.file.getPath(), element, entity.getQualifiedName()}));
        }

        @Override
        public void close() throws IOException {
            if (this.br != null) {
                this.br.close();
            }
        }
    }
}

