/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl;

import com.sap.cds.feature.config.Properties;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.handler.EventPredicate;
import com.sap.cds.services.handler.Handler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.impl.Phase;
import com.sap.cds.services.impl.ServiceSPI;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.info.CdsInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class ServiceCatalogInfo
implements CdsInfo {
    private CdsRuntime runtime;

    public String name() {
        return "services";
    }

    public void setRuntime(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public Map<String, Object> info(CdsInfo.Details flavor) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.runtime != null) {
            ServiceCatalog catalog = this.runtime.getServiceCatalog();
            catalog.getServices().forEach(service -> {
                HashMap serviceMap = new HashMap();
                Stream.of(Info.values()).filter(i -> flavor.compareTo((Enum)i.minFlavor) >= 0).forEach(info -> {
                    Object value = info.valueFunc.apply((Service)service);
                    if (value != null) {
                        serviceMap.put(info.name, value);
                    }
                });
                result.put(service.getName(), serviceMap);
            });
        }
        return result;
    }

    private static String type(Service service) {
        return service.getClass().getName();
    }

    private static Object properties(Service service) {
        return Properties.getCds().getApplication().getServices().values().stream().filter(srv -> service.getName().equals(srv.getName())).findAny().orElse(null);
    }

    private static Map<String, Object> handlers(Service service) {
        ServiceSPI serviceSPI = CdsServiceUtils.getServiceSPI(service);
        if (serviceSPI != null) {
            List<HandlerDescription> afterHandlers;
            List<HandlerDescription> onHandlers;
            LinkedHashMap<String, Object> handlers = new LinkedHashMap<String, Object>();
            List<HandlerDescription> beforeHandlers = ServiceCatalogInfo.createHandlerDescriptions(serviceSPI, Phase.BEFORE);
            if (!beforeHandlers.isEmpty()) {
                handlers.put(Before.class.getSimpleName(), beforeHandlers);
            }
            if (!(onHandlers = ServiceCatalogInfo.createHandlerDescriptions(serviceSPI, Phase.ON)).isEmpty()) {
                handlers.put(On.class.getSimpleName(), onHandlers);
            }
            if (!(afterHandlers = ServiceCatalogInfo.createHandlerDescriptions(serviceSPI, Phase.AFTER)).isEmpty()) {
                handlers.put(After.class.getSimpleName(), afterHandlers);
            }
            return handlers;
        }
        return null;
    }

    private static List<HandlerDescription> createHandlerDescriptions(ServiceSPI serviceSPI, Phase phase) {
        ArrayList<HandlerDescription> handlers = new ArrayList<HandlerDescription>();
        serviceSPI.registrations(phase).forEach(r -> {
            HandlerDescription description = new HandlerDescription();
            Handler handler = r.getHandler();
            description.handler = handler.toString();
            EventPredicate predicate = r.getEventPredicate();
            description.predicate = predicate == EventPredicate.ALL ? "event '*' on entity '*'" : r.getEventPredicate().toString();
            handlers.add(description);
        });
        return handlers;
    }

    static class HandlerDescription {
        public String handler;
        public String predicate;

        HandlerDescription() {
        }
    }

    public static enum Info {
        TYPE("type", x$0 -> ServiceCatalogInfo.access$200(x$0), CdsInfo.Details.LOW),
        PROPERTIES("properties", x$0 -> ServiceCatalogInfo.access$100(x$0), CdsInfo.Details.MEDIUM),
        HANDLERS("handlers", x$0 -> ServiceCatalogInfo.access$000(x$0), CdsInfo.Details.HIGH);

        String name;
        Function<Service, ?> valueFunc;
        CdsInfo.Details minFlavor;

        private Info(String name, Function<Service, ?> valueFunc, CdsInfo.Details minFlavor) {
            this.name = name;
            this.valueFunc = valueFunc;
            this.minFlavor = minFlavor;
        }

        public String getName() {
            return this.name;
        }
    }
}

