/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.CdsDataProcessor;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.TenantAwareCache;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class FormatAssertionHandler
implements EventHandler {
    private final TenantAwareCache<Map<String, Pattern>, CdsModel> patternCache;

    public FormatAssertionHandler(CdsRuntime runtime) {
        this.patternCache = TenantAwareCache.create(() -> new HashMap(), (CdsRuntime)runtime);
    }

    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=11100)
    public void runCheck(EventContext context) {
        CdsDataProcessor.create().addValidator(FormatAssertionHandler::isStringWithFormat, this::validate).process(CdsServiceUtils.getEntities(context), (CdsStructuredType)context.getTarget());
    }

    private static boolean isStringWithFormat(Path path, CdsElement e, CdsType t) {
        return t.isSimpleType(CdsBaseType.STRING) && CdsAnnotations.ASSERT_FORMAT.getOrValue((CdsAnnotatable)e, null) instanceof String;
    }

    private void validate(Path path, CdsElement element, Object value) {
        if (value != null) {
            Object regex = CdsAnnotations.ASSERT_FORMAT.getOrValue((CdsAnnotatable)element, null);
            Pattern pattern = this.getPattern((String)regex, element.getName(), element.getDeclaringType().getQualifiedName());
            this.ensureValidFormat(value.toString(), pattern, element.getName());
        }
    }

    private Pattern getPattern(String regex, String elementName, String entityName) {
        Pattern pattern = (Pattern)((Map)this.patternCache.findOrCreate()).get(regex);
        if (pattern == null) {
            try {
                pattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_ANNOTATION, new Object[]{CdsAnnotations.ASSERT_FORMAT.toString(), elementName, entityName, e});
            }
            ((Map)this.patternCache.findOrCreate()).put(regex, pattern);
        }
        return pattern;
    }

    private void ensureValidFormat(String elementConvertedValue, Pattern pattern, String elementName) {
        Matcher matcher = pattern.matcher(elementConvertedValue);
        if (!matcher.matches()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_STRING_VALUE, new Object[]{elementName});
        }
    }
}

