/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messaging.handlers;

import com.sap.cds.feature.config.Properties;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.utils.messaging.service.AbstractMessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"ApplicationLifecycleService$Default"})
public class MessagingInitilizationHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(MessagingInitilizationHandler.class);

    @Before(event={"APPLICATION_PREPARED"})
    public void initializeMessagingServices(ApplicationPreparedEventContext context) {
        context.getServiceCatalog().getServices(AbstractMessagingService.class).forEach(service -> service.init());
    }

    @After(event={"APPLICATION_PREPARED"})
    public void validateConfiguredServices(ApplicationPreparedEventContext context) {
        Properties.getCds().getMessaging().getServices().forEach((name, config) -> {
            if (config.isEnabled().booleanValue() && context.getServiceCatalog().getService(config.getName()) == null) {
                logger.warn("No messaging service was created for configuration with name '{}'", (Object)config.getName());
            }
        });
    }
}

