/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messaging.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.impl.messaging.message.S4HanaMessageEventContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class S4HanaMessage {
    private static final SimpleDateFormat timeDecoder = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
    private static ObjectMapper mapper = new ObjectMapper();
    @JsonProperty(value="cloudEventsVersion")
    private String cloudEventsVersion;
    @JsonProperty(value="schemaURL")
    private String schemaURL;
    @JsonProperty(value="contentType")
    private String contentType;
    @JsonProperty(value="source")
    private String source;
    @JsonProperty(value="eventType")
    private String eventType;
    @JsonProperty(value="eventID")
    private String eventID;
    @JsonProperty(value="data")
    private Map<String, Object> data;
    private long eventTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static S4HanaMessage create(String event, Map<String, Object> data) {
        String eventTime;
        SimpleDateFormat simpleDateFormat = timeDecoder;
        synchronized (simpleDateFormat) {
            eventTime = timeDecoder.format(new Date(System.currentTimeMillis()));
        }
        S4HanaMessage result = new S4HanaMessage(eventTime);
        result.eventType = event;
        result.data = data;
        return result;
    }

    public static S4HanaMessage parse(String rawMessage) {
        try {
            S4HanaMessage message = (S4HanaMessage)mapper.readValue(rawMessage, S4HanaMessage.class);
            return message;
        }
        catch (IOException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_S4_MESSAGE, new Object[]{e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S4HanaMessage(@JsonProperty(value="eventTime") String eventTime) {
        if (eventTime != null) {
            try {
                SimpleDateFormat simpleDateFormat = timeDecoder;
                synchronized (simpleDateFormat) {
                    Date date = timeDecoder.parse(eventTime);
                    this.eventTime = date.getTime();
                }
            }
            catch (ParseException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_MESSAGE_TIMESTAMP, new Object[]{e});
            }
        }
    }

    public S4HanaMessageEventContext toS4HanaMessageEventContext() {
        S4HanaMessageEventContext ctx = S4HanaMessageEventContext.create(null, this.eventType);
        ctx.setCloudEventsVersion(this.cloudEventsVersion);
        ctx.setSchemaURL(this.schemaURL);
        ctx.setContentType(this.contentType);
        ctx.setSource(this.source);
        ctx.setEventType(this.eventType);
        ctx.setEventID(this.eventID);
        ctx.setEventTime(this.eventTime);
        ctx.setData(this.data);
        return ctx;
    }
}

