/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl;

import com.sap.cds.Struct;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.impl.EventContextSPI;
import com.sap.cds.services.impl.ServiceSPI;
import com.sap.cds.services.impl.request.RequestContextImpl;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.impl.utils.NameOnlyCdsEntity;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ClassMethods;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.ResultUtils;
import com.sap.cds.services.utils.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EventContextImpl
implements EventContextSPI {
    private static final ClassMethods eventContextImplMethods = ClassMethods.create(EventContextImpl.class);
    private final Map<String, Object> map = new HashMap<String, Object>();
    private Service service;
    private final String event;
    private final String entityName;
    private CdsEntity target;
    private boolean completed = false;

    public EventContextImpl(String event, String entityName) {
        this.event = event;
        this.entityName = StringUtils.isEmpty((String)entityName) ? null : entityName;
    }

    public CdsModel getModel() {
        return this.getRequestContext().getModel();
    }

    public ServiceCatalog getServiceCatalog() {
        return this.getRequestContext().getServiceCatalog();
    }

    public ParameterInfo getParameterInfo() {
        return this.getRequestContext().getParameterInfo();
    }

    public UserInfo getUserInfo() {
        return this.getRequestContext().getUserInfo();
    }

    public Messages getMessages() {
        return this.getRequestContext().getMessages();
    }

    public CdsRuntime getCdsRuntime() {
        ServiceSPI serviceSPI = CdsServiceUtils.getServiceSPI(this.service);
        return serviceSPI != null ? serviceSPI.getCdsRuntime() : null;
    }

    private RequestContext getRequestContext() {
        return RequestContext.getCurrent((CdsRuntime)this.getCdsRuntime());
    }

    public ChangeSetContext getChangeSetContext() {
        return ChangeSetContext.getCurrent();
    }

    public Service getService() {
        return this.service;
    }

    @Override
    public void setService(Service service) {
        this.service = service;
    }

    public String getEvent() {
        return this.event;
    }

    public CdsEntity getTarget() {
        RequestContext context;
        if (this.entityName == null) {
            return null;
        }
        if (this.target == null && (context = RequestContextImpl.getCurrentOrNull(this.getCdsRuntime())) != null && context.getModel() != null) {
            this.target = CdsModelUtils.getEntityOrThrow(context.getModel(), this.entityName);
        }
        return this.target != null ? this.target : new NameOnlyCdsEntity(this.entityName);
    }

    public <T extends EventContext> T as(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        EventName expectedEventName = clazz.getAnnotation(EventName.class);
        if (expectedEventName == null || StringUtils.isEmpty((String)expectedEventName.value())) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_CONTEXT_MISSING_ANNOTATION, new Object[]{clazz.getName()});
        }
        if (!expectedEventName.value().equals("*") && !this.event.equals(expectedEventName.value())) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_CONTEXT_EVENT_MISMATCH, new Object[]{clazz.getName(), expectedEventName.value(), this.event});
        }
        EventContext mapAccessor = (EventContext)Struct.access(this.map).as(clazz);
        return (T)((EventContext)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, EventContextSPI.class}, (proxy, method, methodArgs) -> {
            Type[] types;
            Method originalMethod = eventContextImplMethods.lookupMethod(method);
            if (originalMethod != null) {
                if (method.getName().equals("as") && methodArgs.length == 1 && ((Class)methodArgs[0]).isAssignableFrom(clazz)) {
                    return proxy;
                }
                return originalMethod.invoke((Object)this, methodArgs);
            }
            if (method.getName().equals("setResult") && (types = method.getGenericParameterTypes()).length == 1 && types[0].getTypeName().equals("java.lang.Iterable<? extends java.util.Map<java.lang.String, ?>>")) {
                methodArgs[0] = ResultUtils.convert((Iterable)((Iterable)methodArgs[0]));
            }
            Object obj = method.invoke((Object)mapAccessor, methodArgs);
            if (method.getName().equals("setResult")) {
                this.setCompleted();
            }
            return obj;
        }));
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public void put(String key, Object value) {
        this.map.put(key, value);
    }

    public void setCompleted() {
        this.completed = true;
    }

    public boolean isCompleted() {
        return this.completed;
    }
}

