/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl;

import com.sap.cds.ql.StructuredType;
import com.sap.cds.services.ServiceExceptionUtils;
import com.sap.cds.services.impl.messages.MessageTargetImpl;
import com.sap.cds.services.impl.messages.SimpleLocalizedMessageProvider;
import com.sap.cds.services.impl.request.RequestContextImpl;
import com.sap.cds.services.impl.request.RequestContextSPI;
import com.sap.cds.services.messages.LocalizedMessageProvider;
import com.sap.cds.services.messages.MessageTarget;
import java.util.Locale;
import java.util.function.Function;

public class ServiceExceptionUtilsImpl
implements ServiceExceptionUtils {
    public static LocalizedMessageProvider defaultLocalizedMessageProvider = new SimpleLocalizedMessageProvider();

    public String getMessage(String code, Object[] args) {
        return defaultLocalizedMessageProvider.get(code, args, null);
    }

    public String getLocalizedMessage(String code, Object[] args, Locale locale) {
        Locale theLocale = locale;
        if (theLocale == null) {
            RequestContextSPI requestContext = RequestContextImpl.getCurrentInternal();
            theLocale = requestContext != null ? requestContext.getParameterInfo().getLocale() : null;
        }
        return defaultLocalizedMessageProvider.get(code, args, theLocale);
    }

    public MessageTarget getMessageTarget(String target) {
        return MessageTargetImpl.create(target);
    }

    public <E extends StructuredType<E>> MessageTarget getMessageTarget(String prefix, Class<E> entity, Function<E, Object> path) {
        return MessageTargetImpl.create(prefix, entity, path);
    }

    public MessageTarget getMessageTarget(String prefix, String entity, Function<StructuredType<?>, Object> path) {
        return MessageTargetImpl.create(prefix, entity, path);
    }
}

