/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.authorization;

import com.sap.cds.impl.parser.ExpressionParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.utils.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class PredicateResolver {
    private static final Predicate UNRESTRICTED_PRED;
    @Deprecated
    private static final Predicate UNRESTRICTED_DEPRECATED;
    private final CqnPredicate pred;

    private PredicateResolver(CqnPredicate pred) {
        this.pred = pred;
    }

    static PredicateResolver create(String cxnExpression) {
        CqnPredicate pred = StringUtils.isEmpty((String)cxnExpression) ? null : ExpressionParser.parsePredicate((String)cxnExpression);
        return new PredicateResolver(pred);
    }

    CqnPredicate resolve(UserInfo user) {
        if (this.pred == null) {
            return null;
        }
        return CQL.copy((CqnPredicate)this.pred, (Modifier)new UserInfoAttributeSubstitutor(user));
    }

    static {
        UNRESTRICTED_DEPRECATED = UNRESTRICTED_PRED = CQL.literal((Object)1).eq((Object)1);
    }

    private static class UserInfoAttributeSubstitutor
    implements CqnModifier {
        private static final String USER = "$user";
        private static final String TENANT = "tenant";
        private final UserInfo userInfo;

        public UserInfoAttributeSubstitutor(UserInfo userInfo) {
            this.userInfo = userInfo;
        }

        public Predicate comparison(Value<?> lhs, CqnComparisonPredicate.Operator op, Value<?> rhs) {
            if (UserInfoAttributeSubstitutor.isUserAttribute(lhs)) {
                return this.resolveUserAttribute((CqnValue)lhs, (CqnValue)rhs, (user, val) -> CQL.comparison((CqnValue)user, (CqnComparisonPredicate.Operator)op, (CqnValue)val));
            }
            if (UserInfoAttributeSubstitutor.isUserAttribute(rhs)) {
                return this.resolveUserAttribute((CqnValue)rhs, (CqnValue)lhs, (user, val) -> CQL.comparison((CqnValue)val, (CqnComparisonPredicate.Operator)op, (CqnValue)user));
            }
            return CQL.comparison(lhs, (CqnComparisonPredicate.Operator)op, rhs);
        }

        public Predicate exists(Select<?> subQuery) {
            subQuery.where().ifPresent(w -> subQuery.where((CqnPredicate)CQL.copy((CqnPredicate)w, (Modifier)this)));
            return super.exists(subQuery);
        }

        private static boolean isUserAttribute(CqnValue rhs) {
            return rhs.isRef() && USER.equalsIgnoreCase(rhs.asRef().firstSegment());
        }

        private Predicate resolveUserAttribute(CqnValue userAttribute, CqnValue val, BiFunction<CqnValue, CqnValue, Predicate> comparison) {
            List preds;
            List segments = userAttribute.asRef().segments();
            if (segments.size() == 1) {
                return UserInfoAttributeSubstitutor.compare(this.userInfo.getName(), val, comparison);
            }
            String attribute = ((CqnReference.Segment)segments.get(1)).id();
            if (TENANT.equalsIgnoreCase(attribute)) {
                return UserInfoAttributeSubstitutor.compare(this.userInfo.getTenant(), val, comparison);
            }
            if (this.userInfo.isUnrestrictedAttribute(attribute)) {
                return UNRESTRICTED_PRED;
            }
            List attributeValues = this.userInfo.getAttributeValues(attribute);
            List list = preds = attributeValues == null ? Collections.emptyList() : attributeValues.stream().map(v -> (Predicate)comparison.apply((CqnValue)CQL.literal((Object)v), val)).collect(Collectors.toList());
            if (preds.isEmpty()) {
                return UNRESTRICTED_DEPRECATED;
            }
            return CQL.or(preds);
        }

        private static Predicate compare(String attribute, CqnValue val, BiFunction<CqnValue, CqnValue, Predicate> comparison) {
            if (attribute == null) {
                return UNRESTRICTED_DEPRECATED;
            }
            return comparison.apply((CqnValue)CQL.literal((Object)attribute), val);
        }
    }
}

