/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.impl.parser.builder.SortSpecBuilder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnLimit;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.TargetAwareCqnModifier;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.List;
import java.util.Map;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class ImplicitSortingHandler
implements EventHandler {
    @Before
    @HandlerOrder(value=-10700)
    public void implicitSorting(CdsReadEventContext context) {
        CqnSelect select = context.getCqn();
        if (select.from().isRef() && select.groupBy().isEmpty()) {
            CqnSelect copy = (CqnSelect)CQL.copy((CqnStatement)select, (Modifier)new OrderByModifier(context.getTarget()));
            context.setCqn(copy);
        }
    }

    public static class OrderByModifier
    extends TargetAwareCqnModifier {
        private boolean mainItemsContainFunctions = false;

        public OrderByModifier(CdsEntity target) {
            super(target);
        }

        @Override
        protected TargetAwareCqnModifier create(CdsEntity target) {
            return new OrderByModifier(target);
        }

        public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
            this.mainItemsContainFunctions = this.containsFunctions(items);
            return super.items(items);
        }

        public List<CqnSortSpecification> orderBy(List<CqnSortSpecification> orderBy) {
            if (!this.mainItemsContainFunctions) {
                CdsEntity target = this.getTarget();
                this.extendOrderBy(target, orderBy);
            }
            return super.orderBy(orderBy);
        }

        @Override
        public CqnSelectListItem expand(StructuredTypeRef ref, List<CqnSelectListItem> items, List<CqnSortSpecification> orderBy, CqnLimit limit) {
            CdsEntity refTarget = this.getRefTarget(ref);
            if (refTarget != null && !this.containsFunctions(items)) {
                this.extendOrderBy(refTarget, orderBy);
            }
            return super.expand(ref, items, orderBy, limit);
        }

        private void extendOrderBy(CdsEntity target, List<CqnSortSpecification> orderBy) {
            Object defaultOrder = CdsAnnotations.DEFAULT_ORDER.getOrDefault((CdsAnnotatable)target);
            if (defaultOrder != null) {
                if (defaultOrder instanceof List) {
                    ((List)defaultOrder).forEach(o -> this.handleDefaultOrderBy(o, orderBy));
                } else {
                    this.handleDefaultOrderBy(defaultOrder, orderBy);
                }
            }
            target.query().ifPresent(view -> view.orderBy().stream().filter(o -> !this.contains(o.item().displayName(), orderBy)).map(o -> ExpressionVisitor.copy((CqnSortSpecification)o, (Modifier)new CqnModifier(){})).forEach(orderBy::add));
            target.keyElements().filter(e -> e.getType().isSimple()).filter(e -> !this.contains(e.getName(), orderBy)).map(e -> CQL.get((String)e.getName())).map(e -> SortSpecBuilder.by((CqnSelectListValue)e).build()).forEach(orderBy::add);
        }

        private void handleDefaultOrderBy(Object value, List<CqnSortSpecification> orderBy) {
            if (value instanceof Map) {
                Map map = (Map)value;
                Object by = map.get("by");
                Object element = map.get("=");
                if (by instanceof Map) {
                    Object innerElement = ((Map)by).get("=");
                    if (innerElement instanceof String && !this.contains((String)innerElement, orderBy)) {
                        SortSpecBuilder builder = SortSpecBuilder.by((CqnSelectListValue)CQL.get((String)((String)innerElement)));
                        Object desc = map.get("desc");
                        Object asc = map.get("asc");
                        if (Boolean.TRUE.equals(desc)) {
                            builder = builder.desc();
                        } else if (Boolean.TRUE.equals(asc)) {
                            builder = builder.asc();
                        }
                        orderBy.add(builder.build());
                    }
                } else if (element instanceof String && !this.contains((String)element, orderBy)) {
                    orderBy.add(SortSpecBuilder.by((CqnSelectListValue)CQL.get((String)((String)element))).build());
                }
            }
        }

        private boolean contains(String element, List<CqnSortSpecification> orderBy) {
            return orderBy.stream().anyMatch(c -> c.item().displayName().equals(element));
        }

        private boolean containsFunctions(List<CqnSelectListItem> items) {
            return items.stream().anyMatch(item -> item.isValue() && item.asValue().value().isFunction());
        }
    }
}

