/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.draft;

import com.sap.cds.feature.config.Properties;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.draft.CqnAdapter;
import com.sap.cds.services.impl.draft.DraftModifier;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.utils.DraftUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ReferenceModifier
implements CqnModifier {
    public static final String SIBLING = "SiblingEntity";
    public static final String SIBLING_UNSECURED = "SiblingEntity_unsecured";
    private final boolean addSecurityConstraints;
    private boolean forDraft;
    private final boolean modifyIsActiveOnly;
    private final CdsEntity entity;
    private final List<Boolean> followActiveAssociation;
    private final EventContext context;
    private final boolean modifyIsActiveEntity;

    public ReferenceModifier(CdsEntity entity, List<Boolean> followActiveAssociation, boolean addSecurityConstraints, EventContext context) {
        this(entity, false, followActiveAssociation, addSecurityConstraints, context, false);
    }

    public ReferenceModifier(CdsEntity entity, boolean modifyIsActiveOnly, List<Boolean> followActiveAssociation, boolean addSecurityConstraints, EventContext context, boolean modifyIsActiveEntity) {
        this.forDraft = entity.getQualifiedName().endsWith("_drafts");
        this.entity = entity;
        this.followActiveAssociation = followActiveAssociation;
        this.modifyIsActiveOnly = modifyIsActiveOnly;
        this.addSecurityConstraints = addSecurityConstraints;
        this.context = context;
        this.modifyIsActiveEntity = modifyIsActiveEntity;
    }

    public CqnStructuredTypeRef ref(StructuredTypeRef ref) {
        CdsEntity entity = this.entity;
        ArrayList<RefSegment> newSegments = new ArrayList<RefSegment>();
        Iterator<Boolean> iterActiveAssoc = this.followActiveAssociation.iterator();
        boolean isRootEntity = true;
        for (RefSegment segment : ref.segments()) {
            String id = segment.id();
            boolean bl = isRootEntity = isRootEntity && entity.getQualifiedName().equals(id);
            if (SIBLING.equals(id)) {
                this.forDraft = !this.forDraft;
            } else if (SIBLING_UNSECURED.equals(id)) {
                segment.id(SIBLING);
                this.forDraft = !this.forDraft;
            } else if ("DraftAdministrativeData".equals(id) && !this.forDraft) {
                this.forDraft = !this.forDraft;
                newSegments.add(CQL.refSegment((String)SIBLING_UNSECURED));
            } else if (!CdsModelUtils.isAssociationToParentOrChild(id, entity) && entity.findAssociation(id).isPresent() || isRootEntity && DraftUtils.isDraftEnabled((CdsEntity)entity)) {
                if ((entity.findAssociation(id + "_drafts").isPresent() || isRootEntity) && iterActiveAssoc.hasNext()) {
                    boolean bl2 = this.forDraft = iterActiveAssoc.next() == false;
                    if (this.forDraft && !id.endsWith("_drafts")) {
                        CqnPredicate securityConstraints;
                        id = id + "_drafts";
                        segment.id(id);
                        if (this.addSecurityConstraints && (securityConstraints = CqnAdapter.getSecurityConstraints(this.context)) != null) {
                            if (segment.filter().isPresent()) {
                                segment.filter().map(f -> CQL.and((CqnPredicate)f, (CqnPredicate)securityConstraints)).ifPresent(arg_0 -> ((RefSegment)segment).filter(arg_0));
                            } else {
                                segment.filter(securityConstraints);
                            }
                        }
                        if (isRootEntity) {
                            entity = entity.getTargetOf(SIBLING);
                        }
                    } else if (id.endsWith("_drafts")) {
                        id = id.substring(0, id.indexOf("_drafts"));
                        segment.id(id);
                        this.forDraft = false;
                        if (isRootEntity) {
                            entity = entity.getTargetOf(SIBLING);
                        }
                    }
                } else {
                    this.forDraft = false;
                }
            }
            if (!isRootEntity) {
                if (!entity.findAssociation(id).isPresent()) break;
                entity = entity.getTargetOf(id);
            }
            CdsEntity finalEntity = entity;
            segment.filter().map(f -> CQL.copy((CqnPredicate)f, (Modifier)new DraftModifier(finalEntity, this.modifyIsActiveOnly, this.modifyIsActiveEntity))).ifPresent(arg_0 -> ((RefSegment)segment).filter(arg_0));
            newSegments.add(segment);
        }
        return CQL.to(newSegments).asRef();
    }

    public boolean getForDraft() {
        return this.forDraft;
    }

    public static List<List<Boolean>> getAssociationDirections(CqnStatement statement, EventContext context) {
        CqnAnalyzer analyzer = CqnAnalyzer.create((CdsModel)context.getModel());
        AnalysisResult analysisResult = statement.isSelect() ? analyzer.analyze(statement.asSelect()) : (statement.isUpdate() ? analyzer.analyze(statement.asUpdate()) : (statement.isInsert() ? analyzer.analyze(statement.asInsert().ref()) : analyzer.analyze(statement.asDelete())));
        return ReferenceModifier.getAssociationDirections(analysisResult.rootEntity(), statement.ref(), context, analysisResult);
    }

    public static List<List<Boolean>> getAssociationDirections(CdsEntity entity, CqnStructuredTypeRef ref, EventContext context, AnalysisResult analysisResult) {
        Iterator iterRes = null;
        if (analysisResult != null) {
            iterRes = analysisResult.iterator();
        }
        ArrayList<List<Boolean>> result = new ArrayList<List<Boolean>>();
        boolean assocToDraft = Properties.getCds().getDrafts().getAssociationsToInactiveEntities().isEnabled();
        boolean isRootEntity = true;
        for (CqnReference.Segment segment : ref.segments()) {
            String id = segment.id();
            isRootEntity = isRootEntity && id.equals(entity.getQualifiedName());
            Boolean isActiveEntity = ReferenceModifier.determineIsActiveEntity(iterRes, analysisResult, context);
            if (!(isRootEntity || assocToDraft || isActiveEntity == null || isActiveEntity.booleanValue())) {
                result.clear();
                break;
            }
            if (entity.findAssociation(id + "_drafts").isPresent() || isRootEntity && DraftUtils.isDraftEnabled((CdsEntity)entity)) {
                if (result.isEmpty()) {
                    if (isActiveEntity == null || isActiveEntity.booleanValue()) {
                        result.add(new ArrayList<Boolean>(Arrays.asList(true)));
                    }
                    if (!(!assocToDraft && !isRootEntity || isActiveEntity != null && isActiveEntity.booleanValue())) {
                        result.add(new ArrayList<Boolean>(Arrays.asList(false)));
                    }
                } else {
                    ListIterator iterResult = result.listIterator();
                    while (iterResult.hasNext()) {
                        List tmpList = (List)iterResult.next();
                        if (isActiveEntity != null) {
                            tmpList.add(isActiveEntity);
                            continue;
                        }
                        if (assocToDraft) {
                            ArrayList<Boolean> newList = new ArrayList<Boolean>(tmpList);
                            newList.add(false);
                            iterResult.add(newList);
                        }
                        tmpList.add(true);
                    }
                }
            }
            if (isRootEntity) continue;
            if (!entity.findAssociation(id).isPresent()) break;
            entity = entity.getTargetOf(id);
        }
        if (result.isEmpty()) {
            result.add(Collections.emptyList());
        }
        return result;
    }

    private static Boolean determineIsActiveEntity(Iterator<ResolvedSegment> iter, AnalysisResult analysisResult, EventContext context) {
        if (iter != null) {
            Boolean result = (Boolean)iter.next().keyValues().get("IsActiveEntity");
            if (result == null && !iter.hasNext()) {
                if ("DRAFT_CREATE".equals(context.getEvent())) {
                    return false;
                }
                Map targetKeys = analysisResult.targetKeyValues();
                if (targetKeys.get("IsActiveEntity") instanceof Boolean) {
                    result = (Boolean)targetKeys.get("IsActiveEntity");
                }
            }
            return result;
        }
        return null;
    }
}

