/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messages;

import com.sap.cds.impl.builder.model.StructuredTypeProxy;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.services.messages.MessageTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.function.Function;

public class MessageTargetImpl
implements MessageTarget {
    private final String prefix;
    private final List<CqnReference.Segment> path;
    private final String entity;

    public static MessageTarget create(String target) {
        return new MessageTargetImpl(target, null, null);
    }

    public static MessageTarget create(String prefix, String entity, Function<StructuredType<?>, Object> path) {
        return MessageTargetImpl.create(prefix, CQL.to((String)entity), path);
    }

    public static <E extends StructuredType<E>> MessageTarget create(String prefix, Class<E> entity, Function<E, Object> path) {
        return MessageTargetImpl.create(prefix, StructuredTypeProxy.create(entity), path);
    }

    private static MessageTarget create(String prefix, StructuredType<?> entity, Function<StructuredType<?>, Object> path) {
        Object p = path.apply(entity);
        ArrayList<CqnReference.Segment> segments = new ArrayList<CqnReference.Segment>();
        if (p instanceof StructuredType) {
            StructuredType type = (StructuredType)p;
            segments.addAll(type.get("SKIP").segments());
            segments.remove(segments.size() - 1);
        } else if (p instanceof ElementRef) {
            segments.addAll(((ElementRef)p).segments());
        } else {
            return null;
        }
        final Stack entityName = new Stack();
        entity.accept(new CqnVisitor(){

            public void visit(CqnStructuredTypeRef typeRef) {
                entityName.push(typeRef.firstSegment());
            }
        });
        String name = (String)entityName.pop();
        if (name.equals(((CqnReference.Segment)segments.get(0)).id())) {
            segments.remove(0);
        }
        return new MessageTargetImpl(prefix, name, segments);
    }

    private MessageTargetImpl(String prefix, String entity, List<CqnReference.Segment> path) {
        this.prefix = prefix;
        this.entity = entity;
        this.path = path;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getEntity() {
        return this.entity;
    }

    public List<CqnReference.Segment> getPath() {
        return this.path;
    }
}

