/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messaging.file;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedMessagingBroker {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedMessagingBroker.class);
    private static Set<String> createdBrokers = new HashSet<String>();
    private final File file;
    private final WatchService fileWatcher;
    private final Map<String, List<String>> subscriptions = new HashMap<String, List<String>>();
    private final Map<String, List<QueueListener>> listeners = new HashMap<String, List<QueueListener>>();

    private FileBasedMessagingBroker(String name, File exchangeFile) throws IOException {
        this.file = exchangeFile;
        this.fileWatcher = FileSystems.getDefault().newWatchService();
        Path dir = Paths.get(this.file.getParentFile().getAbsolutePath(), new String[0]);
        dir.register(this.fileWatcher, StandardWatchEventKinds.ENTRY_MODIFY);
        new Thread(() -> {
            WatchKey watchKey = null;
            while (true) {
                try {
                    while (true) {
                        if ((watchKey = this.fileWatcher.poll(10L, TimeUnit.MINUTES)) == null) {
                            continue;
                        }
                        if (!watchKey.pollEvents().isEmpty()) {
                            this.receivedRawEvent();
                        }
                        watchKey.reset();
                    }
                }
                catch (InterruptedException e) {
                    logger.debug("File watching timed out, restarting watcher.");
                    continue;
                }
                break;
            }
        }, "FileBasedBroker: " + name).start();
    }

    public static FileBasedMessagingBroker connect(String name, File exchangeFile) throws IOException {
        if (createdBrokers.contains(exchangeFile.getAbsolutePath())) {
            throw new IOException(String.format("The file based messaging broker for '%s' was already created!", exchangeFile.getAbsolutePath()));
        }
        FileBasedMessagingBroker broker = new FileBasedMessagingBroker(name, exchangeFile);
        createdBrokers.add(exchangeFile.getAbsolutePath());
        return broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivedRawEvent() {
        ArrayList<MessageListeners> listeners = new ArrayList<MessageListeners>();
        try (RandomAccessFile raFile = new RandomAccessFile(this.file, "rw");){
            FileChannel channel = raFile.getChannel();
            FileLock lock = null;
            try {
                MessageLine line;
                lock = this.obtainFileLock(60000L, channel);
                ArrayList<MessageLine> leftLines = new ArrayList<MessageLine>();
                while ((line = this.readNextLine(raFile)) != null) {
                    if (!line.isValid()) continue;
                    List<QueueListener> queListeners = this.getQueueListeners(line.getTopic());
                    if (queListeners != null) {
                        listeners.add(new MessageListeners(line, queListeners));
                        continue;
                    }
                    leftLines.add(line);
                }
                if (!listeners.isEmpty()) {
                    raFile.setLength(0L);
                    if (!leftLines.isEmpty()) {
                        for (MessageLine l : leftLines) {
                            raFile.write(l.toString().getBytes(StandardCharsets.UTF_8));
                        }
                    }
                }
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                finally {
                    channel.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("Could not read events", (Throwable)e);
        }
        finally {
            listeners.forEach(msg -> msg.getListeners().forEach(listener -> {
                try {
                    listener.received(msg.getMessage().getData(), msg.getMessage().getTopic(), msg.getMessage().getId());
                }
                catch (Throwable th) {
                    logger.error("error in the handler implementation!", th);
                }
            }));
        }
    }

    private MessageLine readNextLine(RandomAccessFile file) throws IOException {
        String line = file.readLine();
        if (line != null) {
            return new MessageLine(line);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueueListener> getQueueListeners(String topic) {
        Map<String, List<String>> map = this.subscriptions;
        synchronized (map) {
            ArrayList<QueueListener> result = new ArrayList<QueueListener>();
            this.subscriptions.forEach((tpc, queues) -> {
                String pattern = this.getTopicRegexp((String)tpc);
                if (topic.matches(pattern)) {
                    queues.forEach(queue -> {
                        List<QueueListener> qListeners = this.listeners.get(queue);
                        if (qListeners != null && !qListeners.isEmpty()) {
                            result.addAll((Collection)this.listeners.get(queue));
                        }
                    });
                }
            });
            if (!result.isEmpty()) {
                return result;
            }
        }
        return null;
    }

    private String getTopicRegexp(String eventPattern) {
        Objects.requireNonNull(eventPattern, "the topic pattern must not be null");
        return eventPattern.trim().replace("*", "\\*").replaceAll("/\\\\\\*\\\\\\*$", "/.*").replaceAll("\\\\\\*\\s*/", "([^/]*)/").replaceAll("\\\\\\*$", "([^/]*)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitMessage(String topic, String message) {
        try (RandomAccessFile raFile = new RandomAccessFile(this.file, "rw");){
            FileChannel channel = raFile.getChannel();
            FileLock lock = null;
            try {
                lock = this.obtainFileLock(60000L, channel);
                MessageLine line = new MessageLine(topic, message);
                channel.write(ByteBuffer.wrap(line.toString().getBytes(StandardCharsets.UTF_8)), channel.size());
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                finally {
                    channel.close();
                }
            }
        }
        catch (Exception e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EVENT_EMITTING_FAILED, new Object[]{topic, e});
        }
    }

    public void listenToQueue(String queue, QueueListener listener) {
        List<QueueListener> lists;
        if (!this.listeners.containsKey(queue)) {
            this.listeners.put(queue, new ArrayList());
        }
        if (!(lists = this.listeners.get(queue)).contains(listener)) {
            lists.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeTopic(String queue, String topic) {
        Map<String, List<String>> map = this.subscriptions;
        synchronized (map) {
            List<String> queues;
            if (!this.subscriptions.containsKey(topic)) {
                this.subscriptions.put(topic, new ArrayList());
            }
            if (!(queues = this.subscriptions.get(topic)).contains(queue)) {
                queues.add(queue);
            }
        }
    }

    private FileLock obtainFileLock(long timeout, FileChannel channel) throws IOException, InterruptedException, TimeoutException {
        Long quitTime = System.currentTimeMillis() + timeout;
        do {
            try {
                FileLock lock = channel.tryLock();
                if (lock != null) {
                    return lock;
                }
                Thread.sleep(1000L);
            }
            catch (OverlappingFileLockException e) {
                Thread.sleep(1000L);
            }
        } while (System.currentTimeMillis() < quitTime);
        throw new TimeoutException();
    }

    private static class MessageLine {
        private JSONObject data;
        private boolean valid;
        private boolean isCloudEvent;

        public MessageLine(String line) throws IOException {
            try {
                this.data = new JSONObject(line);
                this.valid = true;
                this.isCloudEvent = this.isCloudEvent(this.data);
            }
            catch (Throwable th) {
                throw new IOException("Invalid line representation!", th);
            }
        }

        private MessageLine(String topic, String data) {
            this.data = this.getCloudEvent(data);
            if (this.data == null) {
                this.data = new JSONObject();
                this.data.put("data", (Object)data);
                this.isCloudEvent = true;
            } else {
                this.isCloudEvent = false;
            }
            this.data.put("event", (Object)topic);
            if (!this.data.has("id")) {
                this.data.put("id", (Object)UUID.randomUUID().toString());
            }
        }

        private boolean isCloudEvent(JSONObject event) {
            return event.has("data") && event.has("type") && event.has("source") && event.has("specversion");
        }

        private JSONObject getCloudEvent(String event) {
            try {
                JSONObject cloudEvent = new JSONObject(event);
                if (this.isCloudEvent(cloudEvent)) {
                    return cloudEvent;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        public String getTopic() {
            return this.data.get("event").toString();
        }

        public String getId() {
            return this.data.get("id").toString();
        }

        public String getData() {
            return this.isCloudEvent ? this.data.toString() : this.data.get("data").toString();
        }

        public boolean isValid() {
            return this.valid;
        }

        public String toString() {
            return this.data.toString() + System.lineSeparator();
        }
    }

    private static class MessageListeners {
        MessageLine message;
        List<QueueListener> listeners;

        public MessageListeners(MessageLine message, List<QueueListener> listeners) {
            this.message = message;
            this.listeners = listeners;
        }

        public MessageLine getMessage() {
            return this.message;
        }

        public List<QueueListener> getListeners() {
            return this.listeners;
        }
    }

    public static interface QueueListener {
        public void received(String var1, String var2, String var3);
    }
}

