/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messaging.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.feature.config.Properties;
import com.sap.cds.feature.config.pojo.CdsProperties;
import com.sap.cds.feature.platform.ApplicationProperties;
import com.sap.cds.feature.platform.PlatformEnvironment;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.impl.messaging.message.CdsMessageEventContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.UUID;

public class CdsMessage {
    private static ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    @JsonProperty(value="specversion")
    private String specversion;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="source")
    private String source;
    @JsonProperty(value="subject")
    private String subject;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="datacontenttype")
    private String datacontenttype;
    @JsonProperty(value="dataschema")
    private String dataschema;
    @JsonProperty(value="sappassport")
    private String sappassport;
    @JsonProperty(value="time")
    private String time;
    @JsonProperty(value="data")
    private Map<String, Object> data;

    public static CdsMessage create(String service, String event, Map<String, Object> data) {
        CdsMessage result = new CdsMessage();
        result.specversion = "1.0";
        result.datacontenttype = "application/json";
        result.time = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(Instant.now().atZone(ZoneId.of("UTC")));
        result.id = UUID.randomUUID().toString();
        CdsProperties.Application.ApplicationServiceConfig serviceCfg = Properties.getCds().getApplication().getService(service);
        if (serviceCfg != null) {
            result.source = serviceCfg.getSource();
        }
        if (result.source == null) {
            ApplicationProperties appProperties = PlatformEnvironment.INSTANCE.getApplicationProperties();
            result.source = "/default/" + appProperties.getApplicationName();
        }
        result.type = service + '.' + event;
        result.data = data;
        return result;
    }

    public static CdsMessage parse(String jsonString) {
        try {
            return (CdsMessage)mapper.readValue(jsonString, CdsMessage.class);
        }
        catch (IOException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_CDS_MESSAGE, new Object[]{e});
        }
    }

    public CdsMessageEventContext toCdsMessageEventContext() {
        String event = this.type;
        if (this.type.indexOf(46) != -1) {
            event = this.type.substring(this.type.lastIndexOf(46) + 1);
        }
        CdsMessageEventContext ctx = CdsMessageEventContext.create(event);
        ctx.setSpecVersion(this.specversion);
        ctx.setType(this.type);
        ctx.setSource(this.source);
        ctx.setSubject(this.subject);
        ctx.setId(this.id);
        ctx.setDataContentType(this.datacontenttype);
        ctx.setDataSchema(this.dataschema);
        ctx.setSapPassport(this.sappassport);
        ctx.setTime(Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(this.time)));
        ctx.setData(this.data);
        return ctx;
    }
}

