/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.request;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.Objects;
import java.util.function.Function;

public class RequestContextHelper
implements RequestContext {
    private final CdsRuntime runtime;

    RequestContextHelper(CdsRuntime runtime) {
        Objects.requireNonNull(runtime, "runtime must not be null");
        this.runtime = runtime;
    }

    public CdsModel getModel() {
        return this.temporaryContext(r -> r.getModel());
    }

    public ServiceCatalog getServiceCatalog() {
        return this.temporaryContext(r -> r.getServiceCatalog());
    }

    public ParameterInfo getParameterInfo() {
        return this.temporaryContext(r -> r.getParameterInfo());
    }

    public UserInfo getUserInfo() {
        return this.temporaryContext(r -> r.getUserInfo());
    }

    public Messages getMessages() {
        return this.temporaryContext(r -> r.getMessages());
    }

    private <T> T temporaryContext(Function<RequestContext, T> function) {
        return (T)this.runtime.requestContext().run(newContext -> function.apply((RequestContext)newContext));
    }
}

