/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.request;

import com.sap.cds.services.impl.request.ModifiableUserInfoImpl;
import com.sap.cds.services.request.ModifiableUserInfo;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.request.UserInfoFactory;

public class UserInfoFactoryImpl
implements UserInfoFactory {
    private static UserInfo ANONYMOUS_USER = new UserInfo(){

        public String getName() {
            return "anonymous";
        }

        public boolean isSystemUser() {
            return false;
        }

        public boolean isAuthenticated() {
            return false;
        }
    };
    private static UserInfo PRIVILEGED_USER = new UserInfo(){

        public String getName() {
            return "privileged";
        }

        public boolean isPrivileged() {
            return true;
        }

        public boolean hasRole(String role) {
            return true;
        }

        public boolean isSystemUser() {
            return true;
        }

        public boolean isAuthenticated() {
            return true;
        }
    };

    public ModifiableUserInfo create(UserInfo userInfo) {
        return new ModifiableUserInfoImpl(userInfo != null ? userInfo : UserInfoFactoryImpl.anonymousUserInfo());
    }

    public static UserInfo anonymousUserInfo() {
        return ANONYMOUS_USER;
    }

    public static UserInfo privilegedUserInfo() {
        return PRIVILEGED_USER;
    }
}

