/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.runtime;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.Service;
import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.impl.ServiceCatalogImpl;
import com.sap.cds.services.impl.ServiceCatalogSPI;
import com.sap.cds.services.impl.ServiceExceptionUtilsImpl;
import com.sap.cds.services.impl.ServiceSPI;
import com.sap.cds.services.impl.handlerregistry.HandlerRegistryTools;
import com.sap.cds.services.impl.messages.SimpleLocalizedMessageProvider;
import com.sap.cds.services.impl.request.ParameterInfoImpl;
import com.sap.cds.services.impl.request.UserInfoImpl;
import com.sap.cds.services.impl.runtime.ChangeSetContextRunnerImpl;
import com.sap.cds.services.impl.runtime.RequestContextRunnerImpl;
import com.sap.cds.services.impl.runtime.mockusers.MockedUserInfoProvider;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.messages.LocalizedMessageProvider;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.AuthenticationInfoProvider;
import com.sap.cds.services.runtime.CdsModelProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.ChangeSetContextRunner;
import com.sap.cds.services.runtime.ParameterInfoProvider;
import com.sap.cds.services.runtime.Request;
import com.sap.cds.services.runtime.RequestContextRunner;
import com.sap.cds.services.runtime.UserInfoProvider;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsRuntimeImpl
implements CdsRuntime {
    private static final Logger logger = LoggerFactory.getLogger(CdsRuntimeImpl.class);
    private static final String basePackage = "com.sap.cds.";
    private final ServiceCatalogImpl serviceCatalog = new ServiceCatalogImpl();
    private CdsModel cdsModel = CdsModelUtils.loadCdsModel(null);
    private CdsModelProvider cdsModelProvider = this::tenantIndependentModelProvider;
    private UserInfoProvider userInfoProvider = new MockedUserInfoProvider(this);
    private AuthenticationInfoProvider authenticationInfoProvider = () -> null;
    private ParameterInfoProvider parameterInfoProvider = () -> null;
    private LocalizedMessageProvider localizedMessageProvider = new SimpleLocalizedMessageProvider();

    CdsRuntimeImpl() {
    }

    public ServiceCatalogSPI getServiceCatalog() {
        return this.serviceCatalog;
    }

    public CdsModel getCdsModel() {
        return this.cdsModel;
    }

    public CdsModel getCdsModel(String tenant) {
        if (tenant == null) {
            return this.getCdsModel();
        }
        return this.cdsModelProvider.get(tenant);
    }

    public <T> T runInRequestContext(Request request, Function<RequestContext, T> requestHandler) {
        RequestContextRunner runInRequestContext = this.requestContext();
        if (request != null && request.getRequestUser() != null) {
            runInRequestContext.user((UserInfo)new UserInfoImpl(request.getRequestUser()));
        }
        if (request != null && request.getRequestParameters() != null) {
            runInRequestContext.parameters((ParameterInfo)new ParameterInfoImpl(request.getRequestParameters()));
        }
        return (T)runInRequestContext.run(requestHandler);
    }

    public RequestContextRunner requestContext() {
        return new RequestContextRunnerImpl(this);
    }

    public <T> T runInChangeSetContext(Function<ChangeSetContext, T> changeSetHandler) {
        return (T)this.changeSetContext().run(changeSetHandler);
    }

    public ChangeSetContextRunner changeSetContext() {
        return new ChangeSetContextRunnerImpl();
    }

    void setCdsModel(String csnPath) {
        this.cdsModel = CdsModelUtils.loadCdsModel(csnPath);
    }

    void setCdsModel(CdsModel model) {
        this.cdsModel = model;
    }

    void setCdsModelProvider(CdsModelProvider provider) {
        this.cdsModelProvider = provider;
    }

    CdsModelProvider getCdsModelProvider() {
        return this.cdsModelProvider;
    }

    void setUserInfoProvider(UserInfoProvider userInfoProvider) {
        this.userInfoProvider = userInfoProvider;
    }

    UserInfoProvider getUserInfoProvider() {
        return this.userInfoProvider;
    }

    void setAuthenticationInfoProvider(AuthenticationInfoProvider authenticationInfoProvider) {
        this.authenticationInfoProvider = authenticationInfoProvider;
    }

    AuthenticationInfoProvider getAuthenticationInfoProvider() {
        return this.authenticationInfoProvider;
    }

    void setParameterInfoProvider(ParameterInfoProvider parameterInfoProvider) {
        this.parameterInfoProvider = parameterInfoProvider;
    }

    ParameterInfoProvider getParameterInfoProvider() {
        return this.parameterInfoProvider;
    }

    LocalizedMessageProvider getLocalizedMessageProvider() {
        return this.localizedMessageProvider;
    }

    void setLocalizedMessageProvider(LocalizedMessageProvider localizedMessageProvider) {
        this.localizedMessageProvider = localizedMessageProvider;
        ServiceExceptionUtilsImpl.defaultLocalizedMessageProvider = localizedMessageProvider;
    }

    public ParameterInfo getProvidedParameterInfo() {
        ParameterInfo parameterInfo = this.parameterInfoProvider.get();
        return parameterInfo != null ? parameterInfo : ParameterInfo.create();
    }

    public UserInfo getProvidedUserInfo() {
        UserInfo userInfo = this.userInfoProvider.get();
        return userInfo != null ? userInfo : UserInfo.create();
    }

    public AuthenticationInfo getProvidedAuthenticationInfo() {
        return this.authenticationInfoProvider.get();
    }

    public String getLocalizedMessage(String code, Object[] args, Locale locale) {
        return this.localizedMessageProvider.get(code, args, locale);
    }

    void registerService(Service service) {
        this.serviceCatalog.register(service);
        ServiceSPI serviceSPI = CdsServiceUtils.getServiceSPI(service);
        if (serviceSPI != null) {
            serviceSPI.setCdsRuntime(this);
        }
    }

    <T> void registerEventHandler(Class<T> handlerClass, Supplier<T> handlerFactory) {
        HandlerRegistryTools.registerClass(handlerClass, handlerFactory, this.serviceCatalog);
        if (handlerClass.getPackage().getName().startsWith(basePackage)) {
            logger.debug("Registered handler class {}", (Object)handlerClass.getName());
        } else {
            logger.info("Registered handler class {}", (Object)handlerClass.getName());
        }
    }

    private CdsModel tenantIndependentModelProvider(String tenant) {
        return this.cdsModel;
    }
}

