/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.runtime;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.impl.messages.MessagesImpl;
import com.sap.cds.services.impl.request.ParameterInfoFactoryImpl;
import com.sap.cds.services.impl.request.RequestContextImpl;
import com.sap.cds.services.impl.request.RequestContextSPI;
import com.sap.cds.services.impl.request.UserInfoFactoryImpl;
import com.sap.cds.services.request.ModifiableParameterInfo;
import com.sap.cds.services.request.ModifiableUserInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.RequestContextRunner;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class RequestContextRunnerImpl
implements RequestContextRunner {
    private final CdsRuntime cdsRuntime;
    private final RequestContextSPI currentRequestContext;
    private UserInfo userInfo;
    private ParameterInfo parameterInfo;
    private boolean clearMessages = false;

    public RequestContextRunnerImpl(CdsRuntime cdsRuntime) {
        this.cdsRuntime = Objects.requireNonNull(cdsRuntime, "cdsRuntime must not be null");
        this.currentRequestContext = RequestContextImpl.getCurrentInternal();
        if (this.currentRequestContext != null) {
            this.userInfo = this.currentRequestContext.getUserInfo();
            this.parameterInfo = this.currentRequestContext.getParameterInfo();
        } else {
            this.userInfo = this.providedUserInfo();
            if (this.userInfo == null) {
                this.userInfo = UserInfoFactoryImpl.anonymousUserInfo();
            }
            this.parameterInfo = this.providedParameterInfo();
            if (this.parameterInfo == null) {
                this.parameterInfo = ParameterInfoFactoryImpl.emptyParameterInfo();
            }
        }
        assert (this.userInfo != null);
        assert (this.parameterInfo != null);
    }

    public RequestContextRunner user(UserInfo userInfo) {
        Objects.requireNonNull(userInfo, "userInfo must not be null");
        this.userInfo = userInfo;
        return this;
    }

    public RequestContextRunner anonymousUser() {
        this.userInfo = UserInfoFactoryImpl.anonymousUserInfo();
        return this;
    }

    public RequestContextRunner providedUser() {
        this.userInfo = this.providedUserInfo();
        return this;
    }

    public RequestContextRunner privilegedUser() {
        String tenant = this.userInfo.getTenant();
        this.userInfo = UserInfoFactoryImpl.privilegedUserInfo();
        this.modifyUser(u -> u.setTenant(tenant));
        return this;
    }

    public RequestContextRunner modifyUser(Consumer<ModifiableUserInfo> contextUser) {
        UserInfo prevUserInfo = this.userInfo;
        ModifiableUserInfo modifiedUser = prevUserInfo.copy();
        if (contextUser != null) {
            contextUser.accept(modifiedUser);
        }
        this.userInfo = modifiedUser;
        return this;
    }

    public RequestContextRunner parameters(ParameterInfo parameterInfo) {
        Objects.requireNonNull(parameterInfo, "parameterInfo must not be null");
        this.parameterInfo = parameterInfo;
        return this;
    }

    public RequestContextRunner clearParameters() {
        this.parameterInfo = ParameterInfoFactoryImpl.emptyParameterInfo();
        return this;
    }

    public RequestContextRunner providedParameters() {
        this.parameterInfo = this.providedParameterInfo();
        return this;
    }

    public RequestContextRunner modifyParameters(Consumer<ModifiableParameterInfo> contextParamters) {
        ParameterInfo prevParameterInfo = this.parameterInfo;
        ModifiableParameterInfo modifiedParameter = prevParameterInfo.copy();
        if (contextParamters != null) {
            contextParamters.accept(modifiedParameter);
        }
        this.parameterInfo = modifiedParameter;
        return this;
    }

    public RequestContextRunner clearMessages() {
        this.clearMessages = true;
        return this;
    }

    public void run(Consumer<RequestContext> requestHandler) {
        this.run((RequestContext requestContext) -> {
            requestHandler.accept((RequestContext)requestContext);
            return Void.TYPE;
        });
    }

    public <T> T run(Function<RequestContext, T> requestHandler) {
        ServiceCatalog serviceCatalog = this.cdsRuntime.getServiceCatalog();
        CdsModel cdsModel = this.cdsRuntime.getCdsModel(this.userInfo.getTenant());
        Object messages = !this.clearMessages && this.currentRequestContext != null ? this.currentRequestContext.getMessages() : new MessagesImpl(this.cdsRuntime, this.parameterInfo.getLocale());
        try (RequestContextSPI requestContext = RequestContextImpl.open(cdsModel, serviceCatalog, this.userInfo, this.parameterInfo, messages);){
            T t = requestHandler.apply(requestContext);
            return t;
        }
    }

    private UserInfo providedUserInfo() {
        if (this.cdsRuntime != null) {
            return this.cdsRuntime.getProvidedUserInfo();
        }
        return null;
    }

    private ParameterInfo providedParameterInfo() {
        if (this.cdsRuntime != null) {
            return this.cdsRuntime.getProvidedParameterInfo();
        }
        return null;
    }
}

