/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.messaging.message;

import java.time.Instant;
import java.util.Map;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

/**
 * Describes the content of a CDS structured message, received via the messaging adapter
 */
@EventName("*")
public interface CdsMessageEventContext extends EventContext {

	static CdsMessageEventContext create(String event) {
		return EventContext.create(event, null).as(CdsMessageEventContext.class);
	}

	Map<String, Object> getData();

	void setData(Map<String, Object> data);

	String getSpecVersion();

	void setSpecVersion(String specversion);

	String getType();

	void setType(String type);

	String getSource();

	void setSource(String source);

	String getSubject();

	void setSubject(String subject);

	String getId();

	void setId(String id);

	String getDataContentType();

	void setDataContentType(String datacontenttype);

	String getDataSchema();

	void setDataSchema(String dataschema);

	String getSapPassport();

	void setSapPassport(String sappassport);

	Instant getTime();

	void setTime(Instant time);
}
