/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.persistence;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.messaging.message.ChangedEventContext;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.HashMap;
import java.util.List;

@ServiceName(value={"*"}, type={PersistenceService.class})
public class MessagingHandler
implements EventHandler {
    @After(event={"CREATE", "UPDATE", "DELETE", "UPSERT"})
    public void afterCreate(EventContext context) {
        if (context.getTarget() != null) {
            String entity = context.getTarget().getQualifiedName();
            String event = context.getEvent();
            Service service = context.getServiceCatalog().getService(context.getTarget().getQualifier());
            if (service != null && this.isEmmittable(context.getTarget(), event)) {
                ChangedEventContext changedContext = ChangedEventContext.create(entity);
                changedContext.setData(new HashMap<String, Object>());
                service.emit((EventContext)changedContext);
            }
        }
    }

    private boolean isEmmittable(CdsEntity entity, String event) {
        Object emit = CdsAnnotations.MESSAGING_EMIT.getOrDefault((CdsAnnotatable)entity);
        if (emit != null) {
            if (emit instanceof Boolean) {
                if (((Boolean)emit).booleanValue()) {
                    return true;
                }
            } else if (emit instanceof List) {
                List events = (List)emit;
                return events.stream().map(e -> e.toString()).anyMatch(e -> e.equals(event));
            }
        }
        return false;
    }
}

