/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.helpers.MessageFormatter;

public class ValidatorUtils {
    public static void runNullElementCheck(EventContext context, final Predicate<Object> isNull, final Predicate<CdsElement> isNullNotAllowed, final BiConsumer<Map.Entry<CdsElement, CdsElement>, CdsStructuredType> errorHandler) {
        final boolean isPartialUpdate = "UPDATE".equals(context.getEvent());
        DataProcessor.create().action(new DataProcessor.Action(){

            public void entries(Path path, CdsElement element, CdsStructuredType type, Iterable<Map<String, Object>> entries) {
                List<CdsElement> keyElements = CdsModelUtils.getAssociationKeys(element);
                Map<CdsElement, CdsElement> reducedElements = CdsModelUtils.reduceAssociationElements(type);
                List notNullElements = reducedElements.entrySet().stream().filter(entry -> !keyElements.contains(entry.getKey()) && !keyElements.contains(entry.getValue())).filter(entry -> ValidatorUtils.isNullNotAllowed((CdsElement)entry.getKey(), isNullNotAllowed)).collect(Collectors.toList());
                if (notNullElements.isEmpty()) {
                    return;
                }
                for (Map<String, Object> map : entries) {
                    for (Map.Entry entry2 : notNullElements) {
                        if (isPartialUpdate && !map.containsKey(((CdsElement)entry2.getKey()).getName()) && (entry2.getValue() == null || !map.containsKey(((CdsElement)entry2.getValue()).getName())) || !isNull.test(map.get(((CdsElement)entry2.getKey()).getName())) || !isNull.test(entry2.getValue()) && !isNull.test(map.get(((CdsElement)entry2.getValue()).getName()))) continue;
                        errorHandler.accept(entry2, type);
                    }
                }
            }
        }).process(CdsServiceUtils.getEntitiesResolved(context), (CdsStructuredType)context.getTarget());
    }

    public static boolean isNullNotAllowed(CdsElement element, Predicate<CdsElement> isNullNotAllowed) {
        if (element == null) {
            return false;
        }
        if (element.getType().isSimple() && ((CdsSimpleType)element.getType().as(CdsSimpleType.class)).defaultValue().isPresent()) {
            return false;
        }
        if (element.getType().isAssociation() && element.getName().endsWith("_drafts")) {
            return false;
        }
        return isNullNotAllowed.test(element);
    }

    public static void handleValidationError(EventContext context, CdsErrorStatuses statuses, Object ... args) {
        if (!context.getCdsRuntime().getEnvironment().getCdsProperties().getErrors().isCombined()) {
            throw new ErrorStatusException((ErrorStatus)statuses, args);
        }
        context.getMessages().error(ValidatorUtils.getLocalizedMessage(context, (ErrorStatus)statuses, args), new Object[0]).code(statuses.getCodeString());
    }

    private static String getLocalizedMessage(EventContext context, ErrorStatus errorStatus, Object ... args) {
        String localized = context.getCdsRuntime().getLocalizedMessage(errorStatus.getCodeString(), args, context.getParameterInfo().getLocale());
        if (Objects.equals(localized, errorStatus.getCodeString())) {
            return MessageFormatter.arrayFormat((String)errorStatus.getDescription(), (Object[])args).getMessage();
        }
        return localized;
    }
}

