/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.auditlog;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.auditlog.Access;
import com.sap.cds.services.auditlog.Action;
import com.sap.cds.services.auditlog.AuditLogService;
import com.sap.cds.services.auditlog.ConfigChange;
import com.sap.cds.services.auditlog.ConfigChangeLog;
import com.sap.cds.services.auditlog.ConfigChangeLogContext;
import com.sap.cds.services.auditlog.DataAccessLog;
import com.sap.cds.services.auditlog.DataAccessLogContext;
import com.sap.cds.services.auditlog.DataModification;
import com.sap.cds.services.auditlog.DataModificationLog;
import com.sap.cds.services.auditlog.DataModificationLogContext;
import com.sap.cds.services.auditlog.SecurityLog;
import com.sap.cds.services.auditlog.SecurityLogContext;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.List;
import java.util.Objects;

class AuditLogServiceImpl
extends ServiceDelegator
implements AuditLogService {
    private static final String IS_OUTBOXED = "IS_OUTBOXED";
    private final CdsRuntime runtime;
    private volatile OutboxService outbox;

    AuditLogServiceImpl(String name, CdsRuntime runtime) {
        super(name);
        this.runtime = Objects.requireNonNull(runtime, "runtime must not be null");
    }

    public void logDataAccess(List<Access> accesses) {
        DataAccessLog log = DataAccessLog.create();
        log.setAccesses(accesses);
        DataAccessLogContext context = DataAccessLogContext.create();
        context.setData(log);
        this.emit((EventContext)context);
    }

    public void logDataModification(List<DataModification> modifications) {
        DataModificationLog log = DataModificationLog.create();
        log.setModifications(modifications);
        DataModificationLogContext context = DataModificationLogContext.create();
        context.setData(log);
        this.emit((EventContext)context);
    }

    public void logConfigChange(Action action, List<ConfigChange> configurations) {
        ConfigChangeLog changeLog = ConfigChangeLog.create();
        changeLog.setAction(action);
        changeLog.setConfigurations(configurations);
        ConfigChangeLogContext context = ConfigChangeLogContext.create();
        context.setData(changeLog);
        this.emit((EventContext)context);
    }

    public void logSecurityEvent(String action, String data) {
        SecurityLog log = SecurityLog.create();
        log.setAction(action);
        log.setData(data);
        SecurityLogContext context = SecurityLogContext.create();
        context.setData(log);
        this.emit((EventContext)context);
    }

    public void emit(EventContext context) {
        if (this.shouldBeOutboxed(context)) {
            context.put(IS_OUTBOXED, (Object)true);
            this.getOutboxService().enroll((Service)this, context);
        } else {
            super.emit(context);
        }
    }

    @On
    @HandlerOrder(value=0x7FFFFFFE)
    private void autoComplete(EventContext context) {
        context.setCompleted();
    }

    private boolean shouldBeOutboxed(EventContext context) {
        return context.get(IS_OUTBOXED) == null;
    }

    private OutboxService getOutboxService() {
        if (this.outbox == null) {
            this.outbox = (OutboxService)this.runtime.getServiceCatalog().getService(OutboxService.class, "OutboxService$Default");
        }
        return this.outbox;
    }
}

