/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class LookAheadIterator<T> implements Iterator<T> {

	private Iterator<T> iter;

	private T current = null;

	private T ahead = null;

	public LookAheadIterator(Iterator<T> iter) {
		this.iter = iter;
		move();
	}

	@Override
	public boolean hasNext() {
		return ahead != null;
	}

	@Override
	public T next() {
		if (!hasNext()) {
			throw new NoSuchElementException();
		}
		move();
		return current;
	}

	public T ahead() {
		return ahead;
	}

	private void move() {
		current = ahead;
		if (iter != null && iter.hasNext()) {
			ahead = iter.next();
		} else {
			ahead = null;
		}
	}
}