/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.CdsDataProcessor;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEnumType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.impl.utils.ValidatorUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.stream.Collectors;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class EnumAssertionHandler
implements EventHandler {
    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=11100)
    public void runCheck(EventContext context) {
        CdsDataProcessor.create().addValidator(EnumAssertionHandler::isEnumWithAssertRange, (path, element, elementValue) -> EnumAssertionHandler.ensureValidEnum(context, path, element, elementValue)).process(CdsServiceUtils.getEntities(context), (CdsStructuredType)context.getTarget());
    }

    private static void ensureValidEnum(EventContext context, Path path, CdsElement element, Object elementValue) {
        CdsEnumType enumElement;
        if (elementValue != null && !(enumElement = (CdsEnumType)element.getType()).hasValue(elementValue)) {
            String validEnumValues = enumElement.enumerals().values().stream().map(e -> e.value() + " (" + e.name() + ")").collect(Collectors.joining(", "));
            ValidatorUtils.handleValidationError(context, CdsErrorStatuses.INVALID_ENUM, element.getName(), validEnumValues);
        }
    }

    private static boolean isEnumWithAssertRange(Path path, CdsElement element, CdsType type) {
        return type.isEnum() && !Boolean.FALSE.equals(CdsAnnotations.ASSERT_RANGE.getOrDefault((CdsAnnotatable)element));
    }
}

