/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.ValidatorUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.Map;
import java.util.function.Predicate;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class MandatoryHandler
implements EventHandler {
    @Before(event={"CREATE", "UPDATE", "UPSERT"})
    @HandlerOrder(value=11100)
    public void runCheck(EventContext context) {
        ValidatorUtils.runNullElementCheck(context, obj -> {
            if (obj == null) {
                return true;
            }
            if (obj instanceof String) {
                return StringUtils.isEmpty((String)((String)obj));
            }
            return false;
        }, this.isNullNotAllowed(), (entry, type) -> {
            String elementName = ((CdsElement)entry.getKey()).getName() + (entry.getValue() != null ? "' / '" + ((CdsElement)entry.getValue()).getName() : "");
            String entityName = type.getName();
            ValidatorUtils.handleValidationError(context, CdsErrorStatuses.VALUE_REQUIRED, elementName, entityName);
        });
    }

    protected Predicate<CdsElement> isNullNotAllowed() {
        return cdsElement -> {
            boolean mandatory = CdsAnnotations.MANDATORY.isTrue((CdsAnnotatable)cdsElement);
            Map commonFieldControl = (Map)CdsAnnotations.COMMON_FIELDCONTROL.getOrDefault((CdsAnnotatable)cdsElement);
            return mandatory || commonFieldControl != null && "Mandatory".equals(commonFieldControl.get("#"));
        };
    }
}

