/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.cds;

import com.sap.cds.reflect.CdsService;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.RemoteService;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.impl.cds.ApplicationDefaultOnHandler;
import com.sap.cds.services.impl.cds.ApplicationServiceImpl;
import com.sap.cds.services.impl.cds.AuthorizationHandler;
import com.sap.cds.services.impl.cds.CapabilitiesHandler;
import com.sap.cds.services.impl.cds.EnumAssertionHandler;
import com.sap.cds.services.impl.cds.FormatAssertionHandler;
import com.sap.cds.services.impl.cds.ImplicitSortingHandler;
import com.sap.cds.services.impl.cds.MandatoryHandler;
import com.sap.cds.services.impl.cds.RangeAssertionHandler;
import com.sap.cds.services.impl.cds.ReadOnlyHandler;
import com.sap.cds.services.impl.cds.SingletonHandler;
import com.sap.cds.services.impl.cds.ValidationErrorHandler;
import com.sap.cds.services.impl.messaging.message.CdsMessagingUtils;
import com.sap.cds.services.messaging.MessagingService;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationServiceConfiguration
implements CdsRuntimeConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationServiceConfiguration.class);

    public int order() {
        return 100;
    }

    public static Stream<CdsProperties.Application.ApplicationServiceConfig> applicationServiceConfigs(CdsRuntimeConfigurer configurer, Predicate<? super CdsService> servicePredicate) {
        CdsProperties.Application appConfig = configurer.getCdsRuntime().getEnvironment().getCdsProperties().getApplication();
        ServiceCatalog catalog = configurer.getCdsRuntime().getServiceCatalog();
        return configurer.getCdsRuntime().getCdsModel().services().filter(servicePredicate).map(service -> service.getQualifiedName()).flatMap(name -> {
            List serviceConfigs = appConfig.getServicesByModel(name);
            if (serviceConfigs.isEmpty()) {
                CdsProperties.Application.ApplicationServiceConfig config = appConfig.getService(name);
                if (config.getModel() == null && (appConfig.getServices().values().contains(config) || !catalog.getServices(RemoteService.class).anyMatch(s -> s.getDefinition().getQualifiedName().equals(name)))) {
                    return Stream.of(config);
                }
                return Stream.empty();
            }
            return serviceConfigs.stream();
        }).filter(config -> configurer.getCdsRuntime().getServiceCatalog().getService(config.getName()) == null);
    }

    public void services(CdsRuntimeConfigurer configurer) {
        ApplicationServiceConfiguration.applicationServiceConfigs(configurer, s -> true).map(config -> new ApplicationServiceImpl((CdsProperties.Application.ApplicationServiceConfig)config, configurer.getCdsRuntime())).forEach(arg_0 -> ((CdsRuntimeConfigurer)configurer).service(arg_0));
    }

    public void eventHandlers(CdsRuntimeConfigurer configurer) {
        if (configurer.getCdsRuntime().getServiceCatalog().getServices(ApplicationService.class).findAny().isPresent()) {
            MessagingService messagingService;
            configurer.eventHandler((Object)new ApplicationDefaultOnHandler()).eventHandler((Object)new AuthorizationHandler()).eventHandler((Object)new CapabilitiesHandler()).eventHandler((Object)new SingletonHandler()).eventHandler((Object)new ReadOnlyHandler()).eventHandler((Object)new MandatoryHandler()).eventHandler((Object)new RangeAssertionHandler()).eventHandler((Object)new FormatAssertionHandler(configurer.getCdsRuntime())).eventHandler((Object)new EnumAssertionHandler()).eventHandler((Object)new ValidationErrorHandler());
            if (configurer.getCdsRuntime().getEnvironment().getCdsProperties().getQuery().getImplicitSorting().isEnabled().booleanValue()) {
                configurer.eventHandler((Object)new ImplicitSortingHandler());
            }
            if ((messagingService = CdsMessagingUtils.getMessagingService(configurer.getCdsRuntime())) != null) {
                logger.info("Configuring event handlers for declared events with target '{}'", (Object)messagingService.getName());
                configurer.getCdsRuntime().getServiceCatalog().getServices().filter(s -> s instanceof ApplicationService).map(ApplicationService.class::cast).forEach(applicationService -> applicationService.getDefinition().events().forEach(event -> {
                    String topic = CdsMessagingUtils.getTopic(event);
                    logger.debug("Registering outbound event handler for declared event '{}' on application service '{}' targeting messaging service '{}' with topic '{}'", new Object[]{event.getQualifiedName(), applicationService.getName(), messagingService.getName(), topic});
                    applicationService.on(event.getName(), null, context -> {
                        HashMap data = new HashMap();
                        context.keySet().forEach(key -> data.put(key, context.get(key)));
                        messagingService.emit(topic, data);
                    });
                }));
            }
        }
    }
}

