/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.messages;

import com.sap.cds.impl.builder.model.StructuredTypeProxy;
import com.sap.cds.impl.parser.PathParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.messages.MessageTarget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MessageTargetImpl
implements MessageTarget {
    private final String parameter;
    private final String entity;
    private final CqnReference reference;

    private MessageTargetImpl(String parameter, String entity, CqnReference reference) {
        this.parameter = parameter;
        this.entity = entity;
        this.reference = reference;
    }

    public static MessageTarget create(Path path, CdsElement element) {
        ArrayList segments = new ArrayList();
        String rootEntity = null;
        Iterator iterator = path.iterator();
        if (iterator.hasNext()) {
            ResolvedSegment rootSegment = (ResolvedSegment)iterator.next();
            rootEntity = rootSegment.segment().id();
        }
        iterator.forEachRemaining(resolvedSegment -> segments.add(resolvedSegment.segment()));
        segments.addAll(PathParser.segments((String)element.getName()));
        Object ref = element.getType().isAssociation() ? CQL.to(segments).asRef() : CQL.get(segments).asRef();
        return new MessageTargetImpl(null, rootEntity, (CqnReference)ref);
    }

    public static MessageTarget create(String target) {
        return new MessageTargetImpl(target, null, null);
    }

    public static MessageTarget create(String parameter, Function<StructuredType<?>, Object> path) {
        return MessageTargetImpl.create(parameter, "SKIP", path);
    }

    public static MessageTarget create(String parameter, String rootElement, Function<StructuredType<?>, Object> path) {
        return MessageTargetImpl.create(parameter, CQL.to((String)rootElement), path);
    }

    public static <E extends StructuredType<E>> MessageTarget create(String parameter, Class<E> type, Function<E, Object> path) {
        return MessageTargetImpl.create(parameter, StructuredTypeProxy.create(type), path);
    }

    private static MessageTarget create(String parameter, StructuredType<?> rootElement, Function<StructuredType<?>, Object> path) {
        Object p = path.apply(rootElement);
        ArrayList segments = new ArrayList();
        boolean structured = false;
        if (p instanceof StructuredType) {
            StructuredType type = (StructuredType)p;
            segments.addAll(type.get("SKIP").segments());
            segments.remove(segments.size() - 1);
            structured = true;
        } else if (p instanceof ElementRef) {
            segments.addAll(((ElementRef)p).segments());
        } else {
            return null;
        }
        final Stack entityName = new Stack();
        rootElement.accept(new CqnVisitor(){

            public void visit(CqnStructuredTypeRef typeRef) {
                entityName.push(typeRef.firstSegment());
            }
        });
        String name = (String)entityName.pop();
        if (name.equals(((CqnReference.Segment)segments.get(0)).id())) {
            segments.remove(0);
        }
        if (structured) {
            return new MessageTargetImpl(parameter, name, (CqnReference)CQL.to(segments).asRef());
        }
        return new MessageTargetImpl(parameter, name, (CqnReference)CQL.get(segments).asRef());
    }

    @Deprecated
    public String getPrefix() {
        return this.getParameter();
    }

    @Deprecated
    public String getEntity() {
        return this.entity;
    }

    @Deprecated
    public List<CqnReference.Segment> getPath() {
        if (this.reference != null) {
            return this.reference.segments().stream().collect(Collectors.toList());
        }
        return null;
    }

    public CqnReference getRef() {
        return this.reference;
    }

    public String getParameter() {
        return this.parameter;
    }
}

