/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.request;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.impl.request.RequestContextHelper;
import com.sap.cds.services.impl.request.RequestContextSPI;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContextImpl
implements RequestContextSPI {
    private static final Logger logger = LoggerFactory.getLogger(RequestContextImpl.class);
    private static AtomicInteger idProvider = new AtomicInteger();
    private static final ThreadLocal<Stack<RequestContextImpl>> requestContexts = ThreadLocal.withInitial(() -> new Stack());
    private final CdsModel cdsModel;
    private final ServiceCatalog serviceCatalog;
    private final UserInfo userInfo;
    private final ParameterInfo parameterInfo;
    private final Messages messages;
    private final int id = idProvider.incrementAndGet();
    private final FeatureTogglesInfo featureTogglesInfo;
    private boolean isClosed;

    private RequestContextImpl(CdsModel cdsModel, ServiceCatalog serviceCatalog, UserInfo userInfo, ParameterInfo parameterInfo, FeatureTogglesInfo featureTogglesInfo, Messages messages) {
        this.serviceCatalog = serviceCatalog;
        this.cdsModel = cdsModel;
        this.userInfo = userInfo;
        this.parameterInfo = parameterInfo;
        this.messages = messages;
        this.featureTogglesInfo = featureTogglesInfo;
    }

    public static RequestContextSPI open(CdsModel cdsModel, ServiceCatalog serviceCatalog, UserInfo userInfo, ParameterInfo parameterInfo, FeatureTogglesInfo featureTogglesInfo, Messages messages) {
        RequestContextImpl requestContext = new RequestContextImpl(cdsModel, serviceCatalog, userInfo, parameterInfo, featureTogglesInfo, messages);
        requestContexts.get().push(requestContext);
        logger.debug("Opened RequestContext {}", (Object)requestContext.getId());
        return requestContext;
    }

    @Nonnull
    public static RequestContext getCurrentOrDefault(@Nonnull CdsRuntime cdsRuntime) {
        Object current = RequestContextImpl.getCurrentInternal();
        if (current == null) {
            current = new RequestContextHelper(cdsRuntime);
        }
        return current;
    }

    @Nullable
    public static RequestContext getCurrentOrNull(@Nullable CdsRuntime cdsRuntime) {
        Object current = RequestContextImpl.getCurrentInternal();
        if (current == null && cdsRuntime != null) {
            current = new RequestContextHelper(cdsRuntime);
        }
        return current;
    }

    @Nullable
    public static RequestContextSPI getCurrentInternal() {
        Stack<RequestContextImpl> stack = requestContexts.get();
        return stack.isEmpty() ? null : (RequestContextSPI)stack.peek();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public CdsModel getModel() {
        return this.cdsModel;
    }

    public ServiceCatalog getServiceCatalog() {
        return this.serviceCatalog;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public ParameterInfo getParameterInfo() {
        return this.parameterInfo;
    }

    public Messages getMessages() {
        return this.messages;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        requestContexts.get().pop();
        logger.debug("Closed RequestContext {}", (Object)this.getId());
    }

    public FeatureTogglesInfo getFeatureTogglesInfo() {
        return this.featureTogglesInfo;
    }
}

