/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.impl.utils;

import com.sap.cds.CdsDataProcessor;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.impl.utils.CdsModelUtils;
import com.sap.cds.services.impl.utils.CdsServiceUtils;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.util.OnConditionAnalyzer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.helpers.MessageFormatter;

public class ValidatorUtils {
    public static boolean requiresNotNullCheck(CdsElement element) {
        if (element == null) {
            return false;
        }
        if (element.getType().isSimple() && ((CdsSimpleType)element.getType().as(CdsSimpleType.class)).defaultValue().isPresent()) {
            return false;
        }
        return !element.getType().isAssociation() || !element.getName().endsWith("_drafts");
    }

    public static void runNotNullCheck(EventContext context, Predicate<CdsElement> requiredByModel, CdsDataProcessor.Validator validator) {
        CdsDataProcessor.create().addValidator(ValidatorUtils.requiresNotNullCheck(requiredByModel), validator, CdsDataProcessor.Mode.DECLARED).process(CdsServiceUtils.getEntitiesResolved(context), (CdsStructuredType)context.getTarget());
    }

    private static CdsDataProcessor.Filter requiresNotNullCheck(Predicate<CdsElement> requiredByModel) {
        return (path, element, type) -> {
            CdsElement association;
            List<CdsElement> keyElements;
            if (!requiredByModel.test(element)) {
                return false;
            }
            Iterator segments = path.reverse();
            String lastSegment = ((ResolvedSegment)segments.next()).segment().id();
            return !segments.hasNext() || !(keyElements = CdsModelUtils.getAssociationKeys(association = ((ResolvedSegment)segments.next()).entity().getAssociation(lastSegment))).contains(element);
        };
    }

    public static void handleValidationError(EventContext context, CdsErrorStatuses statuses, Object ... args) {
        if (!context.getCdsRuntime().getEnvironment().getCdsProperties().getErrors().isCombined()) {
            throw new ErrorStatusException((ErrorStatus)statuses, args);
        }
        context.getMessages().error(ValidatorUtils.getLocalizedMessage(context, (ErrorStatus)statuses, args), new Object[0]).code(statuses.getCodeString());
    }

    private static String getLocalizedMessage(EventContext context, ErrorStatus errorStatus, Object ... args) {
        String localized = context.getCdsRuntime().getLocalizedMessage(errorStatus.getCodeString(), args, context.getParameterInfo().getLocale());
        if (Objects.equals(localized, errorStatus.getCodeString())) {
            return MessageFormatter.arrayFormat((String)errorStatus.getDescription(), (Object[])args).getMessage();
        }
        return localized;
    }

    private static List<String> invalidFkElementsOfFwdAssociation(boolean isPartialUpdate, Path path, CdsElement element, Predicate<Object> isNull) {
        boolean isFwdAssociation;
        boolean bl = isFwdAssociation = element.getType().isAssociation() && !com.sap.cds.util.CdsModelUtils.isReverseAssociation((CdsElement)element);
        if (isFwdAssociation) {
            Map parentValues = path.target().values();
            Set fkElements = new OnConditionAnalyzer(element, false).getFkMapping().keySet();
            return fkElements.stream().filter(e -> {
                if (!isPartialUpdate) {
                    return !parentValues.containsKey(e) || isNull.test(parentValues.get(e));
                }
                return parentValues.containsKey(e) && isNull.test(parentValues.get(e));
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static CdsDataProcessor.Validator assertNotNull(EventContext context, Predicate<Object> isNull, BiConsumer<String, String> errorHandler) {
        return (path, element, value) -> {
            boolean notInRequestBody;
            boolean isPartialUpdate = "UPDATE".equals(context.getEvent());
            boolean isAssociation = element.getType().isAssociation();
            boolean bl = notInRequestBody = value == CdsDataProcessor.ABSENT;
            if (isNull.test(value) || !isPartialUpdate && !isAssociation && notInRequestBody) {
                errorHandler.accept(element.getName(), element.getDeclaringType().getQualifiedName());
            } else if (notInRequestBody) {
                for (String e : ValidatorUtils.invalidFkElementsOfFwdAssociation(isPartialUpdate, path, element, isNull)) {
                    errorHandler.accept(e, element.getDeclaringType().getQualifiedName());
                }
            }
        };
    }
}

