package com.sap.cds.services.impl;

import java.util.List;
import java.util.Map;

import com.sap.cds.services.CoreFactory;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceExceptionUtils;
import com.sap.cds.services.changeset.ChangeSetContextAccessor;
import com.sap.cds.services.changeset.ChangeSetContextSPI;
import com.sap.cds.services.environment.PropertiesProvider;
import com.sap.cds.services.impl.changeset.ChangeSetContextAccessorImpl;
import com.sap.cds.services.impl.changeset.ChangeSetContextImpl;
import com.sap.cds.services.impl.request.FeatureTogglesInfoFactory;
import com.sap.cds.services.impl.request.ParameterInfoFactory;
import com.sap.cds.services.impl.request.RequestContextAccessorImpl;
import com.sap.cds.services.impl.request.UserInfoFactory;
import com.sap.cds.services.impl.runtime.CdsRuntimeConfigurerImpl;
import com.sap.cds.services.request.FeatureToggle;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ModifiableParameterInfo;
import com.sap.cds.services.request.ModifiableUserInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContextAccessor;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

public class CoreFactoryImpl implements CoreFactory {

	@Override
	public EventContext createEventContext(String event, String entityName) {
		return new EventContextImpl(event, entityName);
	}

	@Override
	public Service createService(String name) {
		return new ServiceImpl(name);
	}

	@Override
	public Service createService(String name, Service delegator) {
		return new ServiceImpl(name, delegator);
	}

	@Override
	public CdsRuntimeConfigurer createCdsRuntimeConfigurer(PropertiesProvider propertiesProvider) {
		return new CdsRuntimeConfigurerImpl(propertiesProvider);
	}

	@Override
	public RequestContextAccessor createRequestContextAccessor() {
		return new RequestContextAccessorImpl();
	}

	@Override
	public ChangeSetContextAccessor createChangeSetContextAccessor() {
		return new ChangeSetContextAccessorImpl();
	}

	@Override
	public ChangeSetContextSPI createChangeSetContextSPI() {
		return ChangeSetContextImpl.open();
	}

	@Override
	public ModifiableParameterInfo createParameterInfo(ParameterInfo parameterInfo) {
		return ParameterInfoFactory.create(parameterInfo);
	}

	@Override
	public ModifiableUserInfo createUserInfo(UserInfo userInfo) {
		return UserInfoFactory.create(userInfo);
	}

	@Override
	public FeatureTogglesInfo createFeatureTogglesInfo(List<FeatureToggle> featureToggles) {
		return FeatureTogglesInfoFactory.create(featureToggles);
	}

	@Override
	public FeatureTogglesInfo createFeatureTogglesInfo(Map<String, Boolean> featureToggles) {
		return FeatureTogglesInfoFactory.create(featureToggles);
	}

	@Override
	public ServiceExceptionUtils createServiceExceptionUtils() {
		return new ServiceExceptionUtilsImpl();
	}

}
