/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.application;

import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.impl.utils.BuildInfo;
import com.sap.cds.services.utils.OrderConstants;

@ServiceName(value = "*", type = ApplicationLifecycleService.class)
public class ApplicationLifecycleDefaultOnHandler implements EventHandler {

	@On
	@HandlerOrder(OrderConstants.On.DEFAULT_ON)
	void defaultApplicationPrepared(ApplicationPreparedEventContext context) {
		// print the build information
		BuildInfo.log();
		context.setCompleted();
	}

}
