/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.impl.authorization;

import java.util.HashMap;
import java.util.Map;

import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.utils.StringUtils;

public class PredicateLookup {

	private final Map<String, PredicateResolver> cachedPredicatePatterns = new HashMap<>();

	public CqnPredicate resolvePredicate(String cxnExpression, UserInfo user) {

		if (StringUtils.isEmpty(cxnExpression)) {
			return null;
		}

		// calculating the pattern is expensive, so reuse cached
		PredicateResolver cachedPredicatePattern = cachedPredicatePatterns.get(cxnExpression);
		if (cachedPredicatePattern == null) {
			cachedPredicatePattern = PredicateResolver.create(cxnExpression); // throws on syntax error
			cachedPredicatePatterns.put(cxnExpression, cachedPredicatePattern);
		}

		if (cachedPredicatePattern != null) {
			return cachedPredicatePattern.resolve(user);
		}

		return null;
	}
}
